% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_model_2.R
\name{multi_model_2}
\alias{multi_model_2}
\title{Fit and predict in one function}
\usage{
multi_model_2(old_data, new_data, yname, xname, modeltype, ...)
}
\arguments{
\item{old_data}{The data set to which predicted values will be added.}

\item{new_data}{The data set to use for predicting.}

\item{yname}{The dependent variable}

\item{xname}{The independent variable. Supports formulae x1+x2+...}

\item{modeltype}{Currently one of lm, glm and aov. Other models may work with inaccuracies}

\item{...}{Additional arguments to the modeltype}
}
\description{
Fit and predict in one function
}
\examples{
# fit a linear model and get predictions
multi_model_2(iris[1:50,],iris[50:99,],"Sepal.Length","Petal.Length","lm")
# multilinear
multi_model_2(iris[1:50,],iris[50:99,],"Sepal.Length",
    "Petal.Length + Sepal.Width","lm")
# glm
multi_model_2(iris[1:50,],iris[50:99,],"Sepal.Length","Petal.Length","glm")
}
