% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_diffusion.R
\name{measure_infection}
\alias{measure_infection}
\alias{net_infection_complete}
\alias{net_infection_total}
\alias{net_infection_peak}
\title{Measures of network infection}
\usage{
net_infection_complete(diff_model)

net_infection_total(diff_model, normalized = TRUE)

net_infection_peak(diff_model)
}
\arguments{
\item{diff_model}{A valid network diffusion model,
as created by \code{as_diffusion()} or \code{play_diffusion()}.}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}
}
\description{
These functions allow measurement of various features of
a diffusion process at the network level:
\itemize{
\item \code{net_infection_complete()} measures the number of time steps until
(the first instance of) complete infection.
For diffusions that are not observed to complete,
this function returns the value of \code{Inf} (infinity).
This makes sure that at least ordinality is respected.
\item \code{net_infection_total()} measures the proportion or total number of nodes
that are infected/activated at some time by the end of the diffusion process.
This includes nodes that subsequently recover.
Where reinfection is possible, the proportion may be higher than 1.
\item \code{net_infection_peak()} measures the number of time steps until the
highest infection rate is observed.
}
}
\examples{
  smeg <- generate_smallworld(15, 0.025)
  smeg_diff <- play_diffusion(smeg, recovery = 0.2)
  net_infection_complete(smeg_diff)
  net_infection_total(smeg_diff)
  net_infection_peak(smeg_diff)
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{measure_attributes}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_net_diffusion}},
\code{\link{measure_node_diffusion}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}

Other diffusion: 
\code{\link{measure_net_diffusion}},
\code{\link{measure_node_diffusion}},
\code{\link{member_diffusion}},
\code{\link{play}}
}
\concept{diffusion}
\concept{measures}
