% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_hydrobasin.R
\name{esp_get_hydrobasin}
\alias{esp_get_hydrobasin}
\title{Get the drainage basin demarcations of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_hydrobasin(
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "3",
  domain = "land"
)
}
\arguments{
\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with:
\itemize{
\item \code{options(mapSpain_cache_dir = "path/to/dir")}.
}

See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the polygon. Values available are "3", "6.5"
or "10".}

\item{domain}{Possible values are "land", that includes only
the ground part or the ground or "landsea", that includes both the ground
and the related sea waters of the basin}
}
\value{
A \code{POLYGON} object.
}
\description{
Loads a simple feature (\code{sf}) object containing areas with the required
hydrograpic elements of Spain.
}
\details{
Metadata available on
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/}.
}
\examples{
\donttest{
all <- esp_get_prov(moveCAN = FALSE)
hydroland <- esp_get_hydrobasin(domain = "land")
hydrolandsea <- esp_get_hydrobasin(domain = "landsea")

library(tmap)

tm_shape(hydrolandsea, bbox = c(-9.5, 35, 4.5, 44)) +
  tm_fill("skyblue3") +
  tm_shape(all) +
  tm_polygons("grey90") +
  tm_shape(hydroland) +
  tm_polygons("skyblue", alpha = 0.7, border.col = "blue") +
  tm_layout(bg.color = "grey90")
}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{natural}
