% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_railway.R
\name{esp_get_railway}
\alias{esp_get_railway}
\title{Get \code{\link[sf:sf]{sf}} \code{LINESTRING} or \code{POINT} with the railways of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}).
}
\usage{
esp_get_railway(
  year = Sys.Date(),
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "line"
)
}
\arguments{
\item{year}{Release year.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89.
\item \code{"4326"}: WGS84.
\item \code{"3035"}: ETRS89 / ETRS-LAEA.
\item \code{"3857"}: Pseudo-Mercator.
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{spatialtype}{Spatial type of the output. Use \code{"line"}
for extracting the railway as lines and \code{"point"} for extracting
stations.}
}
\value{
A \code{\link[sf:sf]{sf}} \code{LINESTRING} or \code{POINT} object.
}
\description{
Loads a \code{\link[sf:sf]{sf}} \code{LINESTRING} or \code{POINT} object representing the
nodes and railway lines of Spain.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

provs <- esp_get_prov()
ccaa <- esp_get_ccaa()

# Railways
rails <- esp_get_railway()

# Stations
stations <- esp_get_railway(spatialtype = "point")

# Map

library(ggplot2)

ggplot(provs) +
  geom_sf(fill = "grey99", color = "grey50") +
  geom_sf(data = ccaa, fill = NA) +
  geom_sf(
    data = rails, aes(color = tipo),
    show.legend = FALSE, linewidth = 1.5
  ) +
  geom_sf(
    data = stations,
    color = "red", alpha = 0.5
  ) +
  coord_sf(
    xlim = c(-7.5, -2.5),
    ylim = c(38, 41)
  ) +
  scale_color_manual(values = hcl.colors(
    length(unique(rails$tipo)), "viridis"
  )) +
  theme_minimal()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other infrastructure: 
\code{\link{esp_get_roads}()}
}
\concept{infrastructure}
