% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest_ofv_computation.R
\name{qparam}
\alias{qparam}
\title{Quick parameter update}
\usage{
qparam(x, p)
}
\arguments{
\item{x}{model object}

\item{p}{a named list/vector of parameters to update}
}
\value{
model object
}
\description{
Quick parameter update
}
\details{
Faster update of parameters inside the model object. Useful in the context of parameter optimization, otherwise consider the regular \code{param()} because speed comes at the cost of safety.
}
\examples{
library(mrgsolve)
ho <- house()
\dontrun{
system.time(replicate(1000, param(ho, c(CL = .1, VC = 1))))
system.time(replicate(1000, qparam(ho, c(CL = .1, VC = 1))))
}
}
