% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nasa_firms.R
\docType{data}
\name{nasa_firms}
\alias{nasa_firms}
\title{Active Fire Polygon}
\format{
Active fire polygon available for years 2000 to 2021 (MODIS)
and 2012-2021 (VIIRS)
}
\source{
\url{https://firms.modaps.eosdis.nasa.gov/download/}
}
\description{
This resource is published by Fire Information for Resource Management System
(FIRMS) from NASA as Near Real Time (NRT) active fire data. The data is
collected from Moderate Resolution Imaging Spectroradiometer (MODIS) and the
Visible Infrared Imaging Radiometer Suite (VIIRS). The resource represents the
fire hotspot with lat/lon coordinates along with information on fire pixel brightness
temperature, and fire radiative power (frp). The data from MODIS is available from
2000 to 2021 and that from VIIRS is only available for 2012-2021 year range.
}
\details{
The data from the following instruments are available:
\itemize{
\item "MODIS"
\item "VIIRS"
}

The following argument should be specified by users:

\describe{
\item{instrument}{A character vector specifying
the data collection instrument.}
}
}
\references{
NRT VIIRS 375 m Active Fire product VNP14IMGT distributed
from NASA FIRMS. Available on-line https://earthdata.nasa.gov/firms.
doi:10.5067/FIRMS/VIIRS/VNP14IMGT_NRT.002.
}
\keyword{resource}
