% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_paprent_single_map_hmm.R
\name{est_rf_hmm_single_one_parent}
\alias{est_rf_hmm_single_one_parent}
\title{Multilocus analysis using Hidden Markov Models (single parent, single phase)}
\usage{
est_rf_hmm_single_one_parent(
  input.seq,
  input.ph.single,
  info.parent = 1,
  uninfo.parent = 2,
  rf.vec = NULL,
  global.err = 0,
  tol = 0.001,
  verbose = FALSE,
  ret.map.no.rf.estimation = FALSE
)
}
\arguments{
\item{void}{internal function to be documented}
}
\description{
Multilocus analysis using Hidden Markov Models (single parent, single phase)
}
\examples{
  \donttest{
    s <- make_seq_mappoly(solcap.dose.map[[1]])
    full.phase <- solcap.dose.map[[1]]$maps[[1]]$seq.ph
    P1.map <- est_rf_hmm_single_one_parent(s, full.phase, info.parent = 1, 
                                           uninfo.parent = 2)
    plot(P1.map)
    P2.map <- est_rf_hmm_single_one_parent(s, full.phase, info.parent = 2, 
                                           uninfo.parent = 1)
    plot(P2.map)
    plot_map_list(list(Atlantic = P1.map, B1829 = P2.map), , horiz = FALSE)
 }
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
\keyword{internal}
