% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.dataset.R
\name{march.dataset.loadFromFile}
\alias{march.dataset.loadFromFile}
\title{Load a dataset from a file.}
\usage{
march.dataset.loadFromFile(filename, MARGIN = 2, sep = ",",
  weights = NA)
}
\arguments{
\item{filename}{The complete path to the text file containing the dataset.}

\item{MARGIN}{The dimension of the extracted data.frame that contains the sequences (resp 1 for the column, 2 for the rows).}

\item{sep}{A caracter used as element separator on a line.}

\item{weights}{If specified, contains the weight of each sequence.}
}
\value{
a \code{\link{march.Dataset-class}} object containing the data from the file found at \emph{filename}, using separator
\emph{sep}.
}
\description{
The function loads a dataset from a text file, where each row (resp. column) represents 
a data series when \emph{MARGIN} is 2 (resp. 1), using the character \emph{sep} as attribute separator. 
Each data sequence should be stored in a given column, (resp. row).
}
\author{
Ogier Maitre
#'
}
