% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_coef.R, R/methods_MASS.R,
%   R/methods_betareg.R, R/methods_crch.R, R/methods_glmx.R, R/methods_nnet.R,
%   R/methods_pscl.R, R/methods_stats.R
\name{set_coef}
\alias{set_coef}
\alias{set_coef.default}
\alias{set_coef.polr}
\alias{set_coef.betareg}
\alias{set_coef.crch}
\alias{set_coef.hlxr}
\alias{set_coef.glmx}
\alias{set_coef.multinom}
\alias{set_coef.hurdle}
\alias{set_coef.zeroinfl}
\alias{set_coef.glm}
\alias{set_coef.lm}
\title{Internal function to set coefficients

Set the coefficients in a model to different values and return the modified object (internal function)}
\usage{
set_coef(model, coefs)

\method{set_coef}{default}(model, coefs)

\method{set_coef}{polr}(model, coefs)

\method{set_coef}{betareg}(model, coefs)

\method{set_coef}{crch}(model, coefs)

\method{set_coef}{hlxr}(model, coefs)

\method{set_coef}{glmx}(model, coefs)

\method{set_coef}{multinom}(model, coefs)

\method{set_coef}{hurdle}(model, coefs)

\method{set_coef}{zeroinfl}(model, coefs)

\method{set_coef}{glm}(model, coefs)

\method{set_coef}{lm}(model, coefs)
}
\arguments{
\item{model}{object to modify}

\item{coefs}{vector of coefficients to insert in the model object}
}
\value{
Model object of the same class as the \code{model} argument, but with
different stored coefficients.
}
\description{
Internal function to set coefficients

Set the coefficients in a model to different values and return the modified object (internal function)
}
\details{
To compute the variance of marginal effects we need to take the
Jacobian with
}
\keyword{internal}
