% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold.R
\name{kfold_data}
\alias{kfold_data}
\title{Get the data associated with a fold}
\usage{
kfold_data(species_name, data, folds, fold, training)
}
\arguments{
\item{species_name}{Character vector. The name of the species you want get
the fold data for.}

\item{data}{Dataframe. The occurrence or background data you want to get the
fold data for.}

\item{folds}{Dataframe. The occurrence or background folds as created by
\code{kfold_species_background}. Essentially a data.frame with a species
column and the k-fold cross-validation logical vectors.}

\item{fold}{Integer. Indicate which kth fold you want to return data for.}

\item{training}{Logical. If \code{TRUE} then training data is returned else
if \code{FALSE} then test data is returned.}
}
\value{
Filtered version of data.
}
\description{
\code{kfold_data} returns rows from data for a specific species for the kth
fold. The get data from pre-made folds use \code{\link{get_fold_data}}
}
\examples{
## random data folds
set.seed(42)
occ_data <- data.frame(species = rep("Abalistes stellatus", 50),
                       longitude = runif(50, -180, 180), latitude = runif(50, -90, 90))
bg_data <- data.frame(species = rep("background", 1000),
                      longitude = runif(1000, -180, 180), latitude = runif(1000, -90, 90))
folds <- kfold_occurrence_background(occ_data, bg_data)
## alternative with real data (but see also the function get_fold_data)
# occ_data <- get_occurrences("Abalistes stellatus")
# bg_data <- load_background("random")
# folds <- load_folds("random")

## get training and test data for the first fold
occ_training <- kfold_data("Abalistes stellatus", occ_data, folds$occurrence,
                           fold = 1, training = TRUE)
occ_test <- kfold_data("Abalistes stellatus", occ_data, folds$occurrence,
                       fold = 1, training = FALSE)

bg_training <- kfold_data("Abalistes stellatus", bg_data, folds$background,
                          fold = 1, training = TRUE)
bg_test <- kfold_data("Abalistes stellatus", bg_data, folds$background,
                      fold = 1, training = FALSE)

}
\seealso{
\code{\link{lapply_kfold_species}}, \code{\link{get_fold_data}}
}

