% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{summary}
\alias{summary}
\alias{summary,market_model-method}
\alias{summary,market_fit-method}
\title{Model and fit summaries}
\usage{
\S4method{summary}{market_model}(object)

\S4method{summary}{market_fit}(object)
}
\arguments{
\item{object}{An object to be summarized.}
}
\value{
No return value, called for for side effects (print summary).
}
\description{
Methods that summarize models and their estimates.

\code{market_model}: Prints basic information about the
passed model object. In addition to the output of
the \code{\link{show}} method, \code{summary} prints
\itemize{
\item the number of observations,
\item the number of observations in each equation for models with sample
separation, and
\item various categories of variables.
}

\code{market_fit}: Prints basic information about the
passed model fit. In addition to the output of
the model's \code{summary} method, the function prints basic
estimation results. For a maximum likelihood estimation, the function prints
\itemize{
\item the used optimization method,
\item the maximum number of allowed iterations,
\item the relative convergence tolerance (see \code{\link[stats]{optim}}),
\item the convergence status,
\item the initializing parameter values,
\item the estimated coefficients, their standard errors, Z values, and P values, and
\item \eqn{-2 \log L} evaluated at the maximum.
}
For a linear estimation of the equilibrium system, the function prints
\itemize{
\item the used method,
\item the summary of the first stage regression,
\item the summary of the demand (second stage) regression, and
\item the summary of the supply (second stage) regression.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{market_model}: Summarizes the model.

\item \code{market_fit}: Summarizes the model's fit.
}}

\examples{
\donttest{
model <- simulate_model(
  "diseq_stochastic_adjustment", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.1, beta_d0 = 9.8, beta_d = c(0.3, -0.2), eta_d = c(0.6, -0.1),
    # supply coefficients
    alpha_s = 0.1, beta_s0 = 5.1, beta_s = c(0.9), eta_s = c(-0.5, 0.2),
    # price equation coefficients
    gamma = 1.2, beta_p0 = 3.1, beta_p = c(0.8)
  ),
  seed = 556
)

# print model summary
summary(model)

# estimate
fit <- estimate(model)

# print estimation summary
summary(fit)
}
}
