% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregElasticNet.R
\name{gregElasticNet}
\alias{gregElasticNet}
\title{Compute an elastic net regression estimator}
\usage{
gregElasticNet(y, x_sample, x_pop, pi = NULL, alpha = 1,
  model = "linear", pi2 = NULL, var_est = FALSE,
  var_method = "lin_HB", data_type = "raw", N = NULL,
  lambda = "lambda.min", B = 1000, cvfolds = 10, strata = NULL)
}
\arguments{
\item{y}{A numeric vector of the sampled response variable.}

\item{x_sample}{A data frame of the auxiliary data in the sample.}

\item{x_pop}{A data frame of population level auxiliary information.  It must contain the same names as x_sample.  If data_type = "raw", must contain unit level data.  If data_type = "totals" or "means", then contains one row of aggregated, population totals or means for the auxiliary data. Default is "raw".}

\item{pi}{A numeric vector of inclusion probabilities for each sampled unit in y.  If NULL, then simple random sampling without replacement is assumed.}

\item{alpha}{A numeric value between 0 and 1 which signifies the mixing parameter for the lasso and ridge penalties in the elastic net.  When alpha = 1, only a lasso penalty is used.  When alpha = 0, only a ridge penalty is used. Default is alpha = 1.}

\item{model}{A string that specifies the regression model to utilize. Options are "linear" or "logistic".}

\item{pi2}{A square matrix of the joint inclusion probabilities.  Needed for the "lin_HT" variance estimator.}

\item{var_est}{A logical indicating whether or not to compute a variance estimator.  Default is FALSE.}

\item{var_method}{The method to use when computing the variance estimator.  Options are a Taylor linearized technique: "lin_HB"= Hajek-Berger estimator, "lin_HH" = Hansen-Hurwitz estimator, "lin_HTSRS" = Horvitz-Thompson estimator under simple random sampling without replacement, and "lin_HT" = Horvitz-Thompson estimator or a resampling technique: "bootstrap_SRS" = bootstrap variance estimator under simple random sampling without replacement. The default is "lin_HB".}

\item{data_type}{A string that specifies the form of population auxiliary data. The possible values are "raw", "totals" or "means" for whether the user is providing population data at the unit level, aggregated to totals, or aggregated to means.  Default is "raw".}

\item{N}{A numeric value of the population size. If NULL, it is estimated with the sum of the inverse of the pis.}

\item{lambda}{A string specifying how to tune the lambda hyper-parameter.  Only used if model_select = TRUE and defaults to "lambda.min". The possible values are "lambda.min", which is the lambda_value associated with the minimum cross validation error or "lambda.1se", which is the lambda value associated with a cross validation error that is one standard error away from the minimum, resulting in a smaller model.}

\item{B}{The number of bootstrap samples if computing the bootstrap variance estimator.  Default is 1000.}

\item{cvfolds}{The number of folds for the cross-validation to tune lambda.}

\item{strata}{A factor vector of the stratum membership.  If NULL, all units are put into the same stratum.  Must have same length as y.}
}
\value{
A list of output containing:
\itemize{
\item{pop_total: Estimate of population total}
\item{pop_mean: Estimate of the population mean}
\item{pop_total_var: Estimated variance of population total estimate}
\item{pop_mean_var: Estimated variance of population mean estimate}
\item{coefficients: Survey-weighted model coefficients}
}
}
\description{
Calculates a lasso, ridge or elastic net generalized regression estimator for a finite population mean/proportion or total based on sample data collected from a complex sampling design and auxiliary population data.
}
\examples{
library(survey)
data(api)
gregElasticNet(y = apisrs$api00, 
x_sample = apisrs[c("col.grad", "awards", "snum", "dnum", "cnum", "pcttest", "meals", "sch.wide")], 
x_pop = apipop[c("col.grad", "awards", "snum", "dnum", "cnum", "pcttest", "meals", "sch.wide")], 
pi = apisrs$pw^(-1), var_est = TRUE, alpha = .5)

}
\references{
\insertRef{mcc17}{mase}
}
\seealso{
\code{\link{greg}} for a linear or logistic regression model.
}
