% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_mat}
\alias{split_mat}
\alias{split_mat.figure}
\alias{split_mat.matriks}
\title{Split the correct response (Method)}
\usage{
split_mat(obj, vis = TRUE, cell = NULL)

\method{split_mat}{figure}(obj, vis = TRUE, cell = NULL)

\method{split_mat}{matriks}(obj, vis = TRUE, cell = NULL)
}
\arguments{
\item{obj}{The complex figure or the matrix to split}

\item{vis}{logical, split only the visible figures. Default is TRUE}

\item{cell}{integer, The index of the cell to be split. Default is the correct response}
}
\value{
A list of figures of length equal to the number of figures visible in the correct response (vis = TRUE) or to all the figures composing the complex figure (vis = FALSE)

A list of figures of length equal to the number of figures visible in the correct response (vis = TRUE) or to all the figures composing the complex figure (vis = FALSE)

A list of figures of length equal to the number of figures visible in the correct response (vis = TRUE) or to all the figures composing the complex figure (vis = FALSE)
}
\description{
Split all the visible figures composing a cell of the matrix or of a concatenation of figures
}
\section{Methods (by class)}{
\itemize{
\item \code{split_mat(figure)}: Split the correct response

Split all the visible figures composing a cell of the matrix or of a concatenation of figures

\item \code{split_mat(matriks)}: Split all the visible figures composing a cell of the matrix or a concatenation of figures

}}
\examples{
m1 <- mat_apply(hexagon(), hrules = "lty")
# split the elements in the correct response and assign to an object
split_m1 <- split_mat(m1$Sq1)
m1 <- mat_apply(hexagon(), hrules = "lty")
# split the elements in the correct response and assign to an object
split_m1 <- split_mat(m1$Sq1)
m1 <- mat_apply(hexagon(), hrules = "lty")
# split the elements in the correct response and assign to an object
split_m1 <- split_mat(m1)
}
