% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw}
\alias{draw}
\alias{draw.figure}
\alias{draw.matriks}
\alias{draw.responses}
\title{Draw (Method)}
\usage{
draw(
  obj,
  main = NULL,
  canvas = TRUE,
  hide = FALSE,
  bg = "white",
  mar = c(1, 1, 1, 1),
  xlim = 16,
  ...
)

\method{draw}{figure}(
  obj,
  main = NULL,
  canvas = TRUE,
  hide = FALSE,
  bg = "white",
  mar = c(1, 1, 1, 1),
  xlim = 16,
  ...
)

\method{draw}{matriks}(
  obj,
  main = NULL,
  canvas = TRUE,
  hide = FALSE,
  bg = "white",
  mar = c(1, 1, 1, 1),
  xlim = 16,
  ...
)

\method{draw}{responses}(
  obj,
  main = NULL,
  canvas = TRUE,
  hide = FALSE,
  bg = "white",
  mar = c(1, 1, 1, 1),
  xlim = 16,
  distractors = NULL,
  print = FALSE,
  ...
)
}
\arguments{
\item{obj}{The figure/matriks/response list to be drawn}

\item{main}{logical, print the title of the drawing. Default is FALSE}

\item{canvas}{logical, draw the figure on a new canvas. Default is TRUE}

\item{hide}{logical, hide the cell corresponding to the correct response. Default is FALSE}

\item{bg}{character, define the color background. Default is white}

\item{mar}{numeric vector, change margins of the canvas}

\item{xlim}{numeric, change the length of the x axis}

\item{...}{other arguments}

\item{distractors}{character, names of the distractors to be printed}

\item{print}{logical, print all the distractors together (default, FALSE) or one by one (TRUE)}
}
\value{
A graphic

A graphic of the figure

A graphic of the matriks

A graphic of the matriks
}
\description{
Draws single figures, matrices with 9 or 4 cells, or response list of a matriks
}
\section{Methods (by class)}{
\itemize{
\item \code{draw(figure)}: Draw figure

Draw a figure

\item \code{draw(matriks)}: Draw Matriks

Draw a matriks

\item \code{draw(responses)}: Draw response list

Draw the response list of a matriks

}}
\examples{
# draw a circle
draw(circle())
# draw a circle inside the first circle
draw(size(circle(), 2), canvas = FALSE)
# draw a circle
draw.figure(circle())

# draw a circle inside the other
draw.figure(size(circle(), 2), canvas = FALSE)
# draw a matriks
my_mat <- mat_apply(cof(circle(), luck(), pacman()), "shade", "shape")
draw(my_mat)
# generate a matriks
my_mat1 <- mat_apply(cof(s_axe(), luck(), pacman()), "rotate", "shape")
my_mat2 <- mat_apply(dot(), "shade", "shade")
my_mat <- com(my_mat1, my_mat2)
# generate a response list
my_resp <- response_list(my_mat)
# draw response list
draw(my_resp)
}
