% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchMulti-internal.R
\name{students2schools}
\alias{students2schools}
\title{Aggregate Student Data into School Data}
\usage{
students2schools(students, school.cov, school.id)
}
\arguments{
\item{students}{a dataframe of students.}

\item{school.cov}{a character vector of column names in \code{students} that
should be aggregated by school.}

\item{school.id}{the name of the column in \code{students} containing the
unique school identifier.}
}
\value{
a dataframe of aggregated data, with one row for each school and
columns in \code{school.covs} and \code{school.id}.
}
\description{
Takes a dataframe of student-level covariates and aggregates selected
columns into a dataframe of school covariates.
}
\details{
Aggregation is either done by taking averages or by selecting the unique
factor value when a school has only one value for a factor.  As a result,
\code{school.covs} should only include variables that are numeric or do not
vary within schools.
}
\author{
Luke Keele, Penn State University, \email{ljk20@psu.edu}

Sam Pimentel, University of California, Berkeley, \email{spi@berkeley.edu}
}
\keyword{internal}
