% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mce}
\alias{mce}
\title{MC Experiments}
\usage{
mce(seed, niter, N, n, type, method)
}
\arguments{
\item{seed}{seed value for Monte Carlo Experiment}

\item{niter}{number of draws in estimation}

\item{N}{group size (population)}

\item{n}{group size (sample)}

\item{type}{type of the MC Experiment. Either \code{group.members} for randomly sampled group members or \code{counterfactual.groups} for randomly sampled number of counterfactual (or feasible) groups in selection equation (capped at limit max.combs=250)}

\item{method}{either \code{group.members} or \code{counterfactual.groups}}
}
\description{
MC Experiments
}
\examples{
\dontrun{
## 1. Set parameters
mciter <- 2 #500
niter <- 10 #400000
nodes <- 4

## 2. Setup parallel backend to use 4 processors
library(foreach); library(doSNOW)
cl <- makeCluster(4); registerDoSNOW(cl)

## 3. Define foreach loop function
mce.add <- function(mciter, niter, N, n, type, method){
  h <- foreach(i=1:mciter) \%dopar\% {
    library(matchingMarkets)
    mce(seed=i,niter, N, n, type, method)
  }
  do.call(rbind, h)
}

## 4. Run siumlations:

## 4-a. Benchmark study
exp.5.5.ols <- mce.add(mciter=mciter, niter=niter, N=5, n=5,
                       type="group.members", method="outcome")
exp.5.5.ntu <- mce.add(mciter=mciter, niter=niter, N=5, n=5,
                       type="group.members", method="NTU")

## 4-b. Experiment 1: randomly sampled group members
exp.6.5.ols <- mce.add(mciter=mciter, niter=niter, N=6, n=5,
                       type="group.members", method="outcome")
exp.6.5.ntu <- mce.add(mciter=mciter, niter=niter, N=6, n=5,
                       type="group.members", method="NTU")

## 4-c. Experiment 2: randomly sampled counterfactual groups
exp.6.6.ols <- mce.add(mciter=mciter, niter=niter, N=6, n=6,
                       type="counterfactual.groups", method="outcome")
exp.6.6.ntu <- mce.add(mciter=mciter, niter=niter, N=6, n=6,
                       type="counterfactual.groups", method="NTU")

## 5. Stop parallel backend
stopCluster(cl)
}
}
\author{
Thilo Klein
}

