/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateDoubleVector;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.memory.trailing.trail.StoredDoubleVectorTrail;

public final class StoredDoubleVector
implements IStateDoubleVector {
    public static final int MIN_CAPACITY = 8;
    private double[] elementData;
    public int[] worldStamps;
    private StoredInt size;
    private final EnvironmentTrailing environment;
    protected final StoredDoubleVectorTrail myTrail;

    public StoredDoubleVector(EnvironmentTrailing env, int initialSize, double initialValue) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new double[initialCapacity];
        this.worldStamps = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
            this.worldStamps[i] = w;
        }
        this.size = new StoredInt(env, initialSize);
        this.myTrail = env.getDoubleVectorTrail();
    }

    public StoredDoubleVector(EnvironmentTrailing env, double[] entries) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new double[initialCapacity];
        this.worldStamps = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = entries[i];
            this.worldStamps[i] = w;
        }
        this.size = new StoredInt(env, initialSize);
        this.myTrail = env.getDoubleVectorTrail();
    }

    public StoredDoubleVector(EnvironmentTrailing env) {
        this(env, 0, 0.0);
    }

    private boolean rangeCheck(int index) {
        return index < this.size.get() && index >= 0;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.elementData;
            int[] oldStamps = this.worldStamps;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new double[newCapacity];
            this.worldStamps = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
            System.arraycopy(oldStamps, 0, this.worldStamps, 0, this.size.get());
        }
    }

    @Override
    public void add(double i) {
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
        this.worldStamps[newsize - 1] = this.environment.getWorldIndex();
    }

    @Override
    public void remove(int i) {
        System.arraycopy(this.elementData, i, this.elementData, i + 1, this.size.get());
        System.arraycopy(this.worldStamps, i, this.worldStamps, i + 1, this.size.get());
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public void removeLast() {
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public double get(int index) {
        if (this.rangeCheck(index)) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public double quickGet(int index) {
        assert (this.rangeCheck(index));
        return this.elementData[index];
    }

    @Override
    public double set(int index, double val) {
        if (this.rangeCheck(index)) {
            return this.quickSet(index, val);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public double quickSet(int index, double val) {
        assert (this.rangeCheck(index));
        double oldValue = this.elementData[index];
        if (val != oldValue) {
            int oldStamp = this.worldStamps[index];
            if (oldStamp < this.environment.getWorldIndex()) {
                this.myTrail.savePreviousState(this, index, oldValue, oldStamp);
                this.worldStamps[index] = this.environment.getWorldIndex();
            }
            this.elementData[index] = val;
        }
        return oldValue;
    }

    public double _set(int index, double val, int stamp) {
        assert (this.rangeCheck(index));
        double oldval = this.elementData[index];
        this.elementData[index] = val;
        this.worldStamps[index] = stamp;
        return oldval;
    }

    @Override
    public DisposableIntIterator getIterator() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

