/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.cp.solver.constraints.integer.bool.sat.Lits;
import choco.kernel.solver.ContradictionException;

public class WLClause {
    protected final int[] lits;
    protected final Lits voc;
    protected boolean isreg = false;
    protected boolean nogood = false;
    protected int idx = -1;
    protected ClauseStore propagator;

    public WLClause(int[] ps, Lits voc) {
        this.lits = ps;
        this.voc = voc;
    }

    public void setIdx(int id) {
        this.idx = id;
    }

    public int getIdx() {
        return this.idx;
    }

    public int getLitZero() {
        return this.lits[0];
    }

    public void findLiteral(int start) {
        for (int i = start; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            int tlit = this.lits[start];
            this.lits[start] = this.lits[i];
            this.lits[i] = tlit;
            break;
        }
    }

    public boolean register(ClauseStore propagator) throws ContradictionException {
        assert (this.lits.length > 1);
        this.propagator = propagator;
        if (this.isreg) {
            return true;
        }
        this.findLiteral(0);
        if (this.voc.isFalsified(this.lits[0])) {
            propagator.fail();
        }
        this.findLiteral(1);
        if (this.voc.isFalsified(this.lits[1])) {
            this.updateDomain();
        }
        if (this.voc.isFree(this.lits[0]) && this.voc.isFree(this.lits[1])) {
            this.isreg = true;
            this.voc.watch(this.lits[0], this);
            this.voc.watch(this.lits[1], this);
        }
        return this.isreg;
    }

    public void unregister() {
        if (this.isreg) {
            this.voc.unwatch(this.lits[0], this);
            this.voc.unwatch(this.lits[1], this);
        }
    }

    public boolean propagate(int p, int idxcl) throws ContradictionException {
        if (this.lits[0] == p) {
            this.lits[0] = this.lits[1];
            this.lits[1] = p;
        }
        if (this.voc.isSatisfied(this.lits[0])) {
            return false;
        }
        for (int i = 2; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.lits[1] = this.lits[i];
            this.lits[i] = p;
            this.voc.unwatch(p, idxcl);
            this.voc.watch(this.lits[1], this);
            return true;
        }
        this.updateDomain();
        return false;
    }

    public void updateDomain() throws ContradictionException {
        if (this.lits[0] > 0) {
            if (this.voc.boolvars[this.lits[0]].isInstantiatedTo(0)) {
                this.propagator.updateDegree(this.lits);
            }
            this.voc.boolvars[this.lits[0]].instantiate(1, this.propagator, true);
        } else {
            if (this.voc.boolvars[-this.lits[0]].isInstantiatedTo(1)) {
                this.propagator.updateDegree(this.lits);
            }
            this.voc.boolvars[-this.lits[0]].instantiate(0, this.propagator, true);
        }
    }

    public void simplePropagation(ClauseStore propagator) throws ContradictionException {
        int ivalid = -1;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            if (ivalid != -1) {
                return;
            }
            ivalid = i;
        }
        if (ivalid == -1) {
            propagator.fail();
        } else {
            int litzero = this.lits[0];
            this.lits[0] = this.lits[ivalid];
            this.lits[ivalid] = litzero;
            this.updateDomain();
        }
    }

    public boolean update() throws ContradictionException {
        if (this.voc.isFalsified(this.lits[0]) && !this.voc.isSatisfied(this.lits[1])) {
            int temp = this.lits[0];
            this.lits[0] = this.lits[1];
            this.lits[1] = temp;
            this.updateDomain();
        } else if (this.voc.isFalsified(this.lits[1]) && !this.voc.isSatisfied(this.lits[0])) {
            this.updateDomain();
        }
        return this.voc.isFree(this.lits[0]) && this.voc.isFree(this.lits[1]);
    }

    public boolean learnt() {
        return false;
    }

    public int size() {
        return this.lits.length;
    }

    public Lits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.lits, 0, tmp, 0, this.size());
        return tmp;
    }

    public boolean isSatisfied() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            return true;
        }
        return false;
    }

    public Boolean isEntailed() {
        boolean unknown = false;
        for (int i = 0; i < this.lits.length; ++i) {
            Boolean b = this.voc.isEntailed(this.lits[i]);
            if (b == null) {
                unknown = true;
                continue;
            }
            if (!b.booleanValue()) continue;
            return true;
        }
        if (unknown) {
            return null;
        }
        return false;
    }

    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!Lits.isSatisfied(this.lits[i], tuple[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered() {
        return this.isreg;
    }

    public boolean isNogood() {
        return this.nogood;
    }

    public String toString() {
        StringBuilder clname = new StringBuilder(32);
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.lits[i] > 0) {
                clname.append(this.voc.boolvars[this.lits[i]]);
            } else {
                clname.append('!').append(this.voc.boolvars[-this.lits[i]]);
            }
            if (i >= this.lits.length - 1) continue;
            clname.append(" v ");
        }
        return clname.toString();
    }
}

