/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.cp.solver.constraints.global.pack.PackSConstraint;
import choco.cp.solver.search.integer.branching.AssignVar;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class PackDynRemovals
extends AssignVar {
    public final PackSConstraint pack;
    private int reuseVal;

    public PackDynRemovals(VarSelector<IntDomainVar> varSel, ValSelector<IntDomainVar> valHeuri, PackSConstraint pack) {
        super(varSel, valHeuri);
        this.pack = pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEmptyBins(IntDomainVar bin) throws ContradictionException {
        DisposableIntIterator iter = bin.getDomain().getIterator();
        try {
            while (iter.hasNext()) {
                int b = iter.next();
                if (!this.pack.isEmpty(b)) continue;
                bin.remVal(b);
            }
        }
        finally {
            iter.dispose();
        }
    }

    public final void fail() throws ContradictionException {
        this.getManager().solver.getPropagationEngine().raiseContradiction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEquivalentBins(IntDomainVar bin, int bup) throws ContradictionException {
        DisposableIntIterator iter = bin.getDomain().getIterator();
        int space = this.pack.getRemainingSpace(bup);
        try {
            while (iter.hasNext()) {
                int b = iter.next();
                if (this.pack.getRemainingSpace(b) != space) continue;
                bin.remVal(b);
            }
        }
        finally {
            iter.dispose();
        }
    }

    @Override
    public void goUpBranch(IntBranchingDecision decision) throws ContradictionException {
        super.goUpBranch(decision);
        this.reuseVal = decision.getBranchingValue();
        if (this.pack.svars[this.reuseVal].isInstantiated()) {
            this.fail();
        } else if (this.pack.isEmpty(this.reuseVal)) {
            this.removeEmptyBins(decision.getBranchingIntVar());
        } else {
            this.removeEquivalentBins(decision.getBranchingIntVar(), this.reuseVal);
        }
    }
}

