/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.internalConstraints;

import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.ForbiddenRegion;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.variables.geost.ShiftedBox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class DistLinearIC
extends ForbiddenRegion {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    public int o1;
    public int[] a;
    public int b;
    public Setup stp;
    public int D;

    public DistLinearIC(Setup stp_, int[] a, int o1, int b) {
        this.setIctrID(7);
        this.stp = stp_;
        this.a = a;
        this.b = b;
        this.o1 = o1;
        this.D = b;
    }

    @Override
    public List isFeasible(boolean min, int dim, int k, Obj o, Point p, Point jump) {
        int j;
        LOGGER.info("-- ENTERING DistLinearIC.isFeasible;p:" + p + ";jump:" + jump);
        this.D = this.compute_D(k);
        if (this.D < 0) {
            this.D = 0;
        }
        Region f = new Region(k, o.getObjectId());
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        if (!this.insideForbidden(p)) {
            LOGGER.info("Not Inside forbidden");
            result.add(0, Boolean.valueOf(true));
            result.add(1, p);
            return result;
        }
        LOGGER.info("Inside forbidden");
        for (int i = 0; i < k; ++i) {
            int v = p.getCoord(i);
            f.setMinimumBoundary(i, v);
            f.setMaximumBoundary(i, v);
        }
        LOGGER.info("min:" + min);
        int[] m = new int[k];
        int sum = 0;
        for (int i = 0; i < k; ++i) {
            m[i] = this.a[i] > 0 ? this.a[i] * f.getMinimumBoundary(i) : this.a[i] * f.getMaximumBoundary(i);
            sum += m[i];
        }
        LOGGER.info("m1:" + m[0] + ";m2:" + m[1]);
        if (min) {
            for (j = k - 1; j >= 0; --j) {
                int j_prime = (j + dim) % k;
                LOGGER.info("j_prime:" + j_prime);
                if (this.a[j_prime] >= 0) {
                    f.setMaximumBoundary(j_prime, this.stp.getObject(this.o1).getCoord(j_prime).getSup());
                    continue;
                }
                double sup = this.D - (sum - m[j_prime]);
                double inf = this.a[j_prime];
                int term = (int)Math.ceil(sup / inf);
                LOGGER.info("D:" + this.D + ";sum:" + sum + ";m:" + m[j_prime] + ";a:" + this.a[j_prime] + ";term:" + term);
                f.setMaximumBoundary(j_prime, Math.min(jump.getCoord(j_prime) - 1, term - 1));
                m[j_prime] = this.a[j_prime] * f.getMaximumBoundary(j_prime);
            }
        } else {
            for (j = k - 1; j >= 0; --j) {
                int j_prime = (j + dim) % k;
                LOGGER.info("j_prime:" + j_prime);
                if (this.a[j_prime] <= 0) {
                    f.setMinimumBoundary(j_prime, this.stp.getObject(this.o1).getCoord(j_prime).getInf());
                    continue;
                }
                double sup = this.D - (sum - m[j_prime]);
                double inf = this.a[j_prime];
                int term = (int)Math.floor(sup / inf);
                LOGGER.info("D:" + this.D + ";sum:" + sum + ";m:" + m[j_prime] + ";a:" + this.a[j_prime] + ";term:" + term);
                f.setMinimumBoundary(j_prime, Math.max(jump.getCoord(j_prime) + 1, term + 1));
                m[j_prime] = this.a[j_prime] * f.getMinimumBoundary(j_prime);
            }
        }
        LOGGER.info("RETURNING forbidden box:" + f);
        result.add(0, Boolean.valueOf(false));
        result.add(1, f);
        LOGGER.info("-- EXITING ForbiddenRegion.isFeasible");
        return result;
    }

    int compute_D(int k) {
        DisposableIntIterator it = this.stp.getObject(this.o1).getShapeId().getDomain().getIterator();
        int max = 0;
        boolean max_not_assigned = true;
        while (it.hasNext()) {
            int sid = it.next();
            boolean min_sid_not_assigned = true;
            int min_sid = -1;
            for (ShiftedBox sb : this.stp.getShape(sid)) {
                int r = 0;
                for (int i = 0; i < k; ++i) {
                    r += this.a[i] * sb.getOffset(i);
                }
                int sum = 0;
                for (int i = 0; i < k; ++i) {
                    int s_l_i = sb.getSize(i);
                    int max_a_i = Math.max(this.a[i], 0);
                    sum += max_a_i * s_l_i;
                }
                if (min_sid_not_assigned || min_sid > this.b - r - sum) {
                    min_sid = this.b - r - sum;
                }
                min_sid_not_assigned = false;
            }
            if (max_not_assigned || max < min_sid) {
                max = min_sid;
            }
            max_not_assigned = false;
        }
        it.dispose();
        return max;
    }

    @Override
    public boolean insideForbidden(Point p) {
        return this.product(this.a, p) > this.D;
    }

    public int product(int[] v, Point p) {
        int result = 0;
        for (int i = 0; i < v.length; ++i) {
            result += v[i] * p.getCoord(i);
        }
        return result;
    }

    @Override
    public int maximizeSizeOfFBox(boolean min, int d, int k, Region f) {
        int r;
        int[] m = new int[this.a.length];
        for (int i = 0; i < k - 1; ++i) {
            m[i] = this.a[i] > 0 ? this.a[i] * f.getMinimumBoundary(i) : this.a[i] * f.getMaximumBoundary(i);
        }
        if (min) {
            if (this.a[d] >= 0) {
                return this.stp.getObject(this.o1).getCoord(d).getSup();
            }
            this.D = this.b;
            r = 0;
            for (int j = 0; j < k; ++j) {
                if (k == d) continue;
                r += m[j];
            }
            double num = this.D - r;
            double den = this.a[d];
            return (int)Math.ceil(num / den) - 1;
        }
        if (this.a[d] <= 0) {
            return this.stp.getObject(this.o1).getCoord(d).getInf();
        }
        this.D = this.b;
        r = 0;
        for (int j = 0; j < k; ++j) {
            if (k == d) continue;
            r += m[j];
        }
        double num = this.D - r;
        double den = this.a[d];
        return (int)Math.floor(num / den) + 1;
    }
}

