/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import choco.cp.solver.constraints.integer.bool.sat.Vec;
import choco.cp.solver.constraints.integer.bool.sat.WLClause;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class Lits {
    protected int nblits;
    protected IntDomainVar[] boolvars;
    protected Vec<WLClause>[] poswatches;
    protected Vec<WLClause>[] negwatches;

    public void init(IntDomainVar[] vars) {
        this.boolvars = new IntDomainVar[vars.length + 1];
        for (int i = 1; i < vars.length + 1; ++i) {
            if (!vars[i - 1].hasBooleanDomain()) {
                throw new SolverException(vars[i - 1].getName() + " is not a boolean variable");
            }
            this.boolvars[i] = vars[i - 1];
        }
        this.nblits = this.boolvars.length + 1;
        this.poswatches = new Vec[this.nblits];
        this.negwatches = new Vec[this.nblits];
    }

    public boolean isFree(int lit) {
        if (lit < 0) {
            return !this.boolvars[-lit].isInstantiated();
        }
        return !this.boolvars[lit].isInstantiated();
    }

    public boolean isFalsified(int lit) {
        if (lit < 0) {
            return this.boolvars[-lit].isInstantiatedTo(1);
        }
        return this.boolvars[lit].isInstantiatedTo(0);
    }

    public boolean isSatisfied(int lit) {
        if (lit < 0) {
            return this.boolvars[-lit].isInstantiatedTo(0);
        }
        return this.boolvars[lit].isInstantiatedTo(1);
    }

    public Boolean isEntailed(int lit) {
        if (lit < 0) {
            if (!this.boolvars[-lit].isInstantiated()) {
                return null;
            }
            return this.boolvars[-lit].isInstantiatedTo(0);
        }
        if (!this.boolvars[lit].isInstantiated()) {
            return null;
        }
        return this.boolvars[lit].isInstantiatedTo(1);
    }

    public static boolean isSatisfied(int lit, int val) {
        if (lit < 0) {
            return val == 0;
        }
        return val == 1;
    }

    public static boolean isPositive(int lit) {
        return lit > 0;
    }

    public void watch(int lit, WLClause c) {
        if (lit < 0) {
            int rlit = -lit;
            if (this.poswatches[rlit] == null) {
                this.poswatches[rlit] = new Vec();
            }
            this.poswatches[rlit].push(c);
        } else {
            if (this.negwatches[lit] == null) {
                this.negwatches[lit] = new Vec();
            }
            this.negwatches[lit].push(c);
        }
    }

    public void unwatch(int lit, WLClause c) {
        if (lit < 0) {
            this.poswatches[-lit].remove(c);
        } else {
            this.negwatches[lit].remove(c);
        }
    }

    public void unwatch(int lit, int idxClause) {
        if (lit < 0) {
            this.poswatches[-lit].delete(idxClause);
        } else {
            this.negwatches[lit].delete(idxClause);
        }
    }

    public Vec<WLClause> pos_watches(int idx) {
        return this.poswatches[idx];
    }

    public Vec<WLClause> neg_watches(int idx) {
        return this.negwatches[idx];
    }

    public Vec<WLClause> watches(int lit) {
        if (lit < 0) {
            return this.poswatches[-lit];
        }
        return this.negwatches[lit];
    }

    public void reset() {
        for (int i = 0; i < this.nblits; ++i) {
            this.poswatches[i] = null;
            this.negwatches[i] = null;
        }
    }
}

