## ---- echo = FALSE-------------------------------------------------------
knitr::opts_chunk$set(
  warning = FALSE,
  message = FALSE
)
options(digits=4)

## ------------------------------------------------------------------------
library(matlib)   # use the package

## ------------------------------------------------------------------------
A <- matrix(c(13, -4, 2, -4, 11, -2, 2, -2, 8), 3, 3, byrow=TRUE)
A

## ------------------------------------------------------------------------
ev <- eigen(A)
# extract components
(L <- ev$values)
(V <- ev$vectors)

## ------------------------------------------------------------------------
V %*% diag(L) %*% t(V)

## ------------------------------------------------------------------------
diag(L)
zapsmall(t(V) %*% A %*% V)

## ------------------------------------------------------------------------
A1 = L[1] * V[,1] %*% t(V[,1])
A1

A2 = L[2] * V[,2] %*% t(V[,2])
A2

A3 = L[3] * V[,3] %*% t(V[,3])
A3

## ------------------------------------------------------------------------
A1 + A2 + A3
all.equal(A, A1+A2+A3)

## ------------------------------------------------------------------------
sum(A^2)
c( sum(A1^2), sum(A2^2), sum(A3^2) )
sum( sum(A1^2), sum(A2^2), sum(A3^2) )
#' same as tr(A' A)
tr(crossprod(A))

## ------------------------------------------------------------------------
L^2

