% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixCorr-package.R, R/validate_corr_input.R
\docType{package}
\name{matrixCorr-internal}
\alias{matrixCorr}
\alias{matrixCorr-package}
\alias{matrixCorr-internal}
\alias{RcppExports}
\alias{validate_corr_input}
\title{matrixCorr: Collection of Correlation and Association Estimators}
\usage{
validate_corr_input(data)
}
\arguments{
\item{data}{A matrix or data frame. Non-numeric columns are dropped
(data.frame path). For matrix input, storage mode must be integer or double.}
}
\value{
A numeric matrix (type \code{double}) with column names preserved.
}
\description{
Compute correlation and other association matrices from small to very large datasets with simple, 'cor()'-like functions and sensible defaults. Includes options for shrinkage and robustness to improve results in noisy or high-dimensional settings (p >= n), plus convenient print/plot methods for inspection. Implemented with optimised 'C++' backends using 'BLAS'/'OpenMP' and memory-aware symmetric updates. Works with base matrices and data frames, returning standard 'R' objects via a consistent S3 interface. Useful across genomics, agriculture, and machine-learning workflows. Methods based on Ledoit and Wolf (2004) \doi{10.1016/S0047-259X(03)00096-4}; Schäfer and Strimmer (2005) \doi{10.2202/1544-6115.1175}; Lin (1989) \doi{10.2307/2532051}.

Validates and normalizes input for correlation computations. Accepts either a
numeric matrix or a data frame, filters numeric columns, checks dimensions and
missing values, and returns a numeric (double) matrix with preserved
column names.
}
\details{
Rules enforced:
\itemize{
\item Input must be a matrix or data.frame.
\item Only numeric (integer or double) columns are retained (data.frame path).
\item At least two numeric columns are required.
\item All columns must have the same length and \eqn{\ge} 2 observations.
\item Missing values are not allowed.
\item Returns a \code{double} matrix; integer input is converted once.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Prof-ThiagoOliveira/matrixCorr}
  \item Report bugs at \url{https://github.com/Prof-ThiagoOliveira/matrixCorr/issues}
}


\code{\link[=pearson_corr]{pearson_corr()}}, \code{\link[=spearman_rho]{spearman_rho()}}, \code{\link[=kendall_tau]{kendall_tau()}}
}
\author{
\strong{Maintainer}: Thiago de Paula Oliveira \email{toliveira@abacusbio.com} (\href{https://orcid.org/0000-0002-4555-2584}{ORCID})


Thiago de Paula Oliveira
}
\keyword{internal}
