% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4b.bivph.R
\name{bivph}
\alias{bivph}
\title{Constructor function for bivariate phase-type distributions}
\usage{
bivph(alpha = NULL, S11 = NULL, S12 = NULL, S22 = NULL, dimensions = c(3, 3))
}
\arguments{
\item{alpha}{A probability vector.}

\item{S11}{A sub-intensity matrix.}

\item{S12}{A matrix.}

\item{S22}{A sub-intensity matrix.}

\item{dimensions}{The dimensions of the bivariate phase-type (if no parameters are provided).}
}
\value{
An object of class \linkS4class{bivph}.
}
\description{
Constructor function for bivariate phase-type distributions
}
\examples{
bivph(dimensions = c(3, 3))
S11 <- matrix(c(-1, .5, .5, -1), 2, 2)
S12 <- matrix(c(.2, .4, .3, .1), 2, 2)
S22 <- matrix(c(-2, 0, 1, -1), 2, 2)
bivph(alpha = c(.5, .5), S11, S12, S22)
}
