% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{sumall_byname}
\alias{sumall_byname}
\title{Sum of all elements in a matrix}
\usage{
sumall_byname(a)
}
\arguments{
\item{a}{the matrix whose elements are to be summed}
}
\value{
the sum of all elements in \code{a} as a numeric
}
\description{
This function is equivalent to \code{a \%>\% rowsums_byname() \%>\% colsums_byname()},
but returns a single numeric value instead of a 1x1 matrix.
}
\examples{
library(dplyr)
m <- matrix(2, nrow=2, ncol=2, dimnames = list(paste0("i", 1:2), paste0("c", 1:2))) \%>\%
  setrowtype("Industry") \%>\% setcoltype("Commodity")
sumall_byname(m)
rowsums_byname(m) \%>\% colsums_byname
# Also works for lists
sumall_byname(list(m,m))
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
sumall_byname(DF$m[[1]])
sumall_byname(DF$m)
res <- DF \%>\% mutate(
  sums = sumall_byname(m)
)
res$sums
}
