% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{aggregate_to_pref_suff_byname}
\alias{aggregate_to_pref_suff_byname}
\title{Aggregate to prefixes or suffixes}
\usage{
aggregate_to_pref_suff_byname(
  a,
  aggregation_map = NULL,
  sep = NULL,
  keep,
  margin = c(1, 2),
  prefix_open = "",
  prefix_close = sep,
  suffix_open = sep,
  suffix_close = "",
  pattern_type = "exact"
)
}
\arguments{
\item{a}{a matrix of list of matrices to be aggregated by prefix or suffix}

\item{aggregation_map}{see \code{aggregate_byname()}}

\item{sep}{see \code{rename_to_pref_suff_byname()}}

\item{keep}{see \code{rename_to_pref_suff_byname()}}

\item{margin}{the dimension over which aggregation is to be performed; \code{1} for rows, \code{2} for columns, or \code{c(1, 2)} for both}

\item{prefix_open}{see \code{rename_to_pref_suff_byname()}}

\item{prefix_close}{see \code{rename_to_pref_suff_byname()}}

\item{suffix_open}{see \code{rename_to_pref_suff_byname()}}

\item{suffix_close}{see \code{rename_to_pref_suff_byname()}}

\item{pattern_type}{see \code{aggregate_byname()}}
}
\value{
an aggregated version of \code{a}
}
\description{
Row and column names are often constructed in the form
\code{prefix_open} \code{prefix} \code{prefix_close} \code{suffix_open} \code{suffix} \code{suffix_close}.
This function performs aggregation by prefix or suffix.
}
\details{
This function is a convenience function, as it bundles sequential calls to two helper functions,
\code{rename_to_pref_suff_byname()} and \code{aggregate_byname()}.
All arguments are passed to the helper functions.
}
\examples{
m <- matrix((1:9), byrow = TRUE, nrow = 3, 
            dimnames = list(c("r1 -> b", "r2 -> b", "r3 -> a"), c("c1 -> z", "c2 -> y", "c3 -> y")))
m
# Aggregation by prefixes does nothing more than rename, because all prefixes are different.
# Doing renaming like this (without also aggregating) is potentially dangerous, because  
# some rows and some columns have same names.
aggregate_to_pref_suff_byname(m, sep = " -> ", keep = "prefix")
# Aggregation by suffix reduces the number of rows and columns, 
# because there are same suffixes in both rows and columns
aggregate_to_pref_suff_byname(m, sep = " -> ", keep = "suffix")
}
