% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{create_colvec_byname}
\alias{create_colvec_byname}
\title{Create column vectors from data}
\usage{
create_colvec_byname(
  .dat,
  dimnames = NA,
  colname = NA,
  matrix.class = lifecycle::deprecated(),
  matrix_class = c("matrix", "Matrix")
)
}
\arguments{
\item{.dat}{Data to be converted to column vectors.}

\item{dimnames}{The dimension names to be used for creating the column vector, in a list format, or as a data frame column
containing a list of the dimension names to be used for each observation.}

\item{colname}{The name of the column of the colvector.}

\item{matrix.class}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{matrix_class} instead.}

\item{matrix_class}{One of "matrix" or "Matrix".
"matrix" creates a \code{base::matrix} object with the \code{matrix()} function.
"Matrix" creates a \code{Matrix::Matrix} object using the \code{matsbyname::Matrix()} function.
This could be a sparse matrix.
Default is "matrix".}
}
\value{
A column vector, a list of column vectors, or a data frame column of column vectors, depending on the
value of \code{.dat} and \code{class}.
}
\description{
This function takes data in the \code{.dat} and creates column vectors.
}
\details{
The row and column names in the resulting column vector are taken from
the names of \code{.dat} and \code{colname}.
If set, \code{dimnames} overrides the names of \code{.dat} and \code{colname}.

This function is a "byname" function that can accept a single number,
a vector, a list, or a data frame in \code{.dat}.

Row types and column types are taken from the row type and column type attributes of \code{.dat}.
}
\examples{
# Works with single numbers
create_colvec_byname(c(r1 = 1) \%>\% setrowtype("rt") \%>\% setcoltype("ct"), 
                     colname = "r1")
# Works with vectors
create_colvec_byname(c(r1 = 1, r2 = 2), colname = "c1")
# Works with a list
create_colvec_byname(list(c(r1 = 1, r2 = 2), c(R1 = 3, R2 = 4, R3 = 5)), 
                     colname = list("c1", "C1"))
# Works in a tibble, too.
# (Must be a tibble, not a data frame, so that names are preserved.)
dat <- list(c(r1 = 1, r2 = 2),
            c(R1 = 2, R2 = 3), 
            c(r1 = 1, r2 = 2, r3 = 3, r4 = 4, r5 = 5, r6 = 6))
cnms <- list("c1", "C1", "c1")
df1 <- tibble::tibble(dat, cnms)
df1
df1 <- df1 \%>\%
  dplyr::mutate(
    colvec_col = create_colvec_byname(dat, colname = cnms)
  )
df1$colvec_col[[1]]
df1$colvec_col[[2]]
df1$colvec_col[[3]]
}
