% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{eigenvalues_byname}
\alias{eigenvalues_byname}
\title{Calculate eigenvalues of a matrix}
\usage{
eigenvalues_byname(a)
}
\arguments{
\item{a}{A matrix or list of matrices.}
}
\value{
A vector of eigenvalues.
}
\description{
Calculate the eigenvalues of a matrix or a list of matrices.
}
\details{
This function pairs with \code{eigenvectors_byname()};
the first value of the result is the eigenvalue
for the eigenvector reported in the first column of the result from \code{eigenvectors_byname()}.
The second value of the result is the eigenvalue
for the eigenvector reported in the second column of the result from \code{eigenvectors_byname()}.
Etc.

Internally, this function uses \code{base::eigen(only.values = TRUE)}.

\code{complete_rows_cols()} is called prior to calculating the eigenvalues.
}
\examples{
m <- matrix(c( 4,  6, 10, 
               3, 10, 13, 
              -2, -6, -8), byrow = TRUE, nrow = 3, ncol = 3, 
            dimnames = list(c("p1", "p2", "p3"), c("p1", "p2", "p3")))
m
eigenvalues_byname(m)
eigenvalues_byname(list(m, 2*m))
DF <- tibble::tibble(m_col = list(m, 2*m)) \%>\% 
  dplyr::mutate(
    eigen_col = eigenvalues_byname(m_col)
  )
DF$eigen_col[[1]]
DF$eigen_col[[2]]
}
