% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stand.String.R
\name{Stand.String}
\alias{Stand.String}
\title{Standarize strings}
\usage{
Stand.String(x, chr = NULL, rep = NULL)
}
\arguments{
\item{x}{text to be standarized}

\item{chr}{character vector of replace characters}

\item{rep}{character vector of replacement characters}
}
\value{
Returns data table with definition of utility functions by range
}
\description{
Function to correct and standarize names, designed to eliminate special characters,
spaces and other characters.
}
\examples{
 x<-c( "H?\\u00da\\u00e0n with C@1_ad1", 
       "M\\u00a1a/\\u00ac\\u00b0r&\\u00eca *_the#-rot", 
       "ju\%LI\\u00d6 a P\\u00e9rs", 
       "(S)tev\\n\\u00e9n\\t los cat\%$" )
 y<-sapply( x, FUN = Stand.String )
 names( y )<-NULL
}
\author{
Julio Andrade, Pedro Guarderas, Andrés Lopez
}

