% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.maze}
\alias{plot.maze}
\alias{lines.maze}
\title{Plot a maze object}
\usage{
\method{plot}{maze}(x, walls = FALSE, ...)

\method{lines}{maze}(x, walls = FALSE, adjust = c(0, 0), ...)
}
\arguments{
\item{x}{A \code{\link{maze}} object.}

\item{walls}{logical value, indicating that the walls of the maze should be
plotted, rather than the paths through the maze. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[graphics]{lines}}}

\item{adjust}{A vector by which to adjust the overall position of the maze.
Should be a numeric vector of length 2, indicating the \code{x} and
\code{y} adjustments, respectively.}
}
\value{
Returns \code{NULL}, invisibly.
}
\description{
Plot a maze object
}
\details{
When plotting, the coordinates for locations in the maze are taken from the
indices of the corresponding locations in the matrix representation. This
means that the plot will appear to be flipped vertically relative to the
matrix representation of the maze.
}
\examples{
m <- maze(10,10)
plot(m, walls = TRUE)
lines(m, lwd = 5, col = 3)
}
