% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_comp.R
\docType{methods}
\name{plot_comp}
\alias{plot_comp}
\alias{plot_comp,mbsts-method}
\title{Plot Posterior State Components}
\usage{
plot_comp(object, slope, local, season, cyc, time = NULL, title = NULL)

\S4method{plot_comp}{mbsts}(object, slope, local, season, cyc, time = NULL, title = NULL)
}
\arguments{
\item{object}{An object of the mbsts class created by a call to the mbsts_function function.}

\item{slope}{A logical vector indicating whether there is trend for each target series, such as c(T,T).}

\item{local}{A logical vector indicating whether there is local level for each target series, such as c(T,T).}

\item{season}{A numerical vector indicating the seasonality for each target series, such as c(12,0).}

\item{cyc}{A logical vector indicating whether there is a cycle component for each target series, such as c(F,T).}

\item{time}{Null or a data frame for time index of the time series. The default value is data.frame(seq(1,n)).}

\item{title}{NULL or a character vector whose entries are titles for the plots of target series' posterior state components, such as c("Posterior State Components of y1", "Posterior State Components of y2"). The default is c("y1","y2",...).}
}
\description{
Plots of the mean of posterior state components of each target series, which is generated by the model training procedure of the MBSTS model.
}
\references{
\Qiu2018

\Ning2021

\Jammalamadaka2019
}
\author{
Jinwen Qiu \email{qjwsnow_ctw@hotmail.com} Ning Ning \email{patricianing@gmail.com}
}
