% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_pearson.R
\name{mc_pearson}
\alias{mc_pearson}
\title{Pearson estimating function}
\usage{
mc_pearson(y_vec, mu_vec, Cfeatures, inv_J_beta = NULL, D = NULL,
  correct = FALSE, compute_variability = FALSE)
}
\arguments{
\item{y_vec}{A vector.}

\item{mu_vec}{A vector.}

\item{Cfeatures}{A list of matrices.}

\item{inv_J_beta}{A matrix.}

\item{D}{A matrix.}

\item{correct}{Logical.}

\item{compute_variability}{Logical.}
}
\value{
A list with three components: (i) a vector of quasi-score
    values, (ii) the sensitivity and (iii) variability matrices
    associated with the Pearson estimating function.
}
\description{
Compute the Pearson estimating function its sensitivity
    and variability matrices.
}
\details{
Compute the Pearson estimating function its sensitivity and
    variability matrices.  For more details see Bonat and Jorgensen
    (2016) equations 6, 7 and 8.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
