% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{set_opts}
\alias{set_opts}
\title{Set global options relating to computational details}
\usage{
set_opts(
  auto.order.block = TRUE,
  chol.inplace = TRUE,
  chol.ordering = 0L,
  PG.approx = TRUE,
  PG.approx.m = -2L,
  CRT.approx.m = 20L,
  max.size.cps.template = 100L
)
}
\arguments{
\item{auto.order.block}{whether Gibbs blocks should be ordered automatically in such a
way that those with the most sparse design matrices come first. This way of ordering
can make Cholesky updates more efficient.}

\item{chol.inplace}{whether sparse Cholesky updates should re-use the same memory location.}

\item{chol.ordering}{an integer passed to CHOLMOD routines determining which reordering
schemes are tried to limit sparse Cholesky fill-in.}

\item{PG.approx}{whether Polya-Gamma draws for logistic binomial models are
approximated by a hybrid gamma convolution approach. If not, \code{BayesLogit::rpg}
is used, which is exact for some values of the shape parameter.}

\item{PG.approx.m}{if \code{PG.approx=TRUE}, the number of explicit gamma draws in the
sum-of-gammas representation of the Polya-Gamma distribution. The remainder (infinite)
convolution is approximated by a single moment-matching gamma draw. Special values are:
\code{-2L} for a default choice depending on the value of the shape parameter and
balancing performance and accuracy, \code{-1L} for a moment-matching normal approximation,
and \code{0L} for a moment-matching gamma approximation.}

\item{CRT.approx.m}{scalar integer specifying the degree of approximation to sampling
from a Chinese Restaurant Table distribution. The approximation is based on Le Cam's theorem.
Larger values yield a slower but more accurate sampler.}

\item{max.size.cps.template}{maximum allowed size in MB of the sparse matrix serving as a 
template for the sparse symmetric crossproduct X'QX of a dgCMatrix X, where Q is a diagonal
matrix subject to change.}
}
\value{
This function sets or resets options in the option environment \code{.opts}.
}
\description{
Set global options relating to computational details
}
\references{
D. Bates, M. Maechler, B. Bolker and S.C. Walker (2015).
   Fitting Linear Mixed-Effects Models Using lme4.
   Journal of Statistical Software 67(1), 1-48.

 Y. Chen, T.A. Davis, W.W. Hager and S. Rajamanickam (2008).
   Algorithm 887: CHOLMOD, supernodal sparse Cholesky factorization and update/downdate.
   ACM Transactions on Mathematical Software 35(3), 1-14.
}
