% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_mec.R
\name{mec}
\alias{mec}
\title{Create a model component object for a regression (fixed effects) component
in the linear predictor with measurement errors in quantitative covariates}
\usage{
mec(
  formula = ~1,
  sparse = NULL,
  X = NULL,
  V = NULL,
  prior = NULL,
  Q0 = NULL,
  b0 = NULL,
  R = NULL,
  r = NULL,
  S = NULL,
  s = NULL,
  lower = NULL,
  upper = NULL,
  name = "",
  debug = FALSE
)
}
\arguments{
\item{formula}{a formula specifying the predictors subject to measurement error
and possibly their variances as well. In the latter case the formula syntax
\code{~ (x1 | V.x1) + (x2 | V.x2) + ...} should be used where \code{x1, x2, ...}
are the names of (quantitative) predictors and \code{V.x1, V.x2, ...} are the names
of the variables holding the corresponding measurement error variances.
If only the predictors are specified
the formula has the usual form \code{~ x1 + x2 + ...}. In that case variances
should be specified using argument \code{V}.
All variable names are looked up in the data frame
passed as \code{data} argument to \code{\link{create_sampler}} or
\code{\link{generate_data}}, or in \code{environment(formula)}.}

\item{sparse}{whether the model matrix associated with \code{formula} should
be sparse. The default is to base this on a simple heuristic.}

\item{X}{a (possibly sparse) design matrix can be specified directly, as an
alternative to the creation of one based on \code{formula}. If \code{X} is
specified \code{formula} is ignored.}

\item{V}{measurement error variance; can contain zeros}

\item{prior}{prior specification for the regression coefficients. Currently only
normal priors are supported, specified using function \code{\link{pr_normal}}.}

\item{Q0}{prior precision matrix for the regression effects. The default is a
zero matrix corresponding to a noninformative improper prior.
It can be specified as a scalar value, as a numeric vector of appropriate
length, or as a matrix object. DEPRECATED, please use argument \code{prior}
instead, i.e. \code{prior = pr_normal(mean = b0.value, precision = Q0.value)}.}

\item{b0}{prior mean for the regression effect. Defaults to a zero vector.
It can be specified as a scalar value or as a numeric vector of
appropriate length. DEPRECATED, please use argument \code{prior}
instead, i.e. \code{prior = pr_normal(mean = b0.value, precision = Q0.value)}.}

\item{R}{optional constraint matrix for equality restrictions R'x = r where
\code{x} is the vector of regression effects.}

\item{r}{right hand side for the equality constraints.}

\item{S}{optional constraint matrix for inequality constraints S'x >= s where
x is the vector of regression effects.}

\item{s}{right hand side for the inequality constraints.}

\item{lower}{as an alternative to \code{s}, \code{lower} and \code{upper} may be specified
for two-sided constraints lower <= S'x <= upper.}

\item{upper}{as an alternative to \code{s}, \code{lower} and \code{upper} may be specified
for two-sided constraints lower <= S'x <= upper.}

\item{name}{the name of the model component. This name is used in the output of the
MCMC simulation function \code{\link{MCMCsim}}. By default the name will be 'reg'
with the number of the model term attached.}

\item{debug}{if \code{TRUE} a breakpoint is set at the beginning of the posterior
draw function associated with this model component. Mainly intended for developers.}
}
\value{
an object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component. Intended
 for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the
\code{formula} argument to \code{\link{create_sampler}} or
\code{\link{generate_data}}. It creates an additive regression term in the
model's linear predictor. Covariates are assumed to be measured subject
to normally distributed errors with zero mean and variance specified using
the \code{formula} or \code{V} arguments. Note that this means that \code{formula}
should only contain quantitative variables, and no intercept.
By default, the prior for the regression
coefficients is improper uniform. A proper normal prior can be set up
using function \code{\link{pr_normal}}, and passed to argument \code{prior}.
It should be noted that \code{\link{pr_normal}} expects a precision matrix
as input for its second argument, and that the prior variance (matrix) is
taken to be the inverse of this precision matrix, where in case the
model's family is \code{"gaussian"} this matrix is additionally
multiplied by the residual scalar variance parameter \code{sigma_^2}.
}
\examples{
\donttest{
# example of Ybarra and Lohr (2008)
m <- 50
X <- rnorm(m, mean=5, sd=3)  # true covariate values
v <- rnorm(m, sd=2)
theta <- 1 + 3*X + v  # true values
psi <- rgamma(m, shape=4.5, scale=2)
e <- rnorm(m, sd=sqrt(psi))  # sampling error
y <- theta + e  # direct estimates
C <- c(rep(3, 10), rep(0, 40))  # measurement error for first 10 values
W <- X + rnorm(m, sd=sqrt(C))  # covariate subject to measurement error

# fit Ybarra-Lohr model
sampler <- create_sampler(
  y ~ 1 + mec(~ 0 + W, V=C) + gen(factor=~local_),
  Q0=1/psi, sigma.fixed=TRUE, linpred="fitted"
)
sim <- MCMCsim(sampler, n.iter=800, n.chain=2, store.all=TRUE, verbose=FALSE)
(summ <- summary(sim))
plot(X, W, xlab="true X", ylab="inferred X")
points(X, summ$mec2_X[, "Mean"], col="green")
abline(0, 1, col="red")
legend("topleft", legend=c("prior mean", "posterior mean"), col=c("black", "green"), pch=c(1,1))
}

}
\references{
L.M. Ybarra and S.L. Lohr (2008).
   Small area estimation when auxiliary information is measured with error.
   Biometrika 95(4), 919-931.

 S. Arima, G.S. Datta and B. Liseo (2015).
   Bayesian estimators for small area models when auxiliary information is measured with error.
   Scandinavian Journal of Statistics 42(2), 518-529.
}
