% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{labels}
\alias{labels}
\alias{labels.dc}
\alias{labels<-}
\title{Get and set the variable labels of a draws component object for a vector-valued parameter}
\usage{
\method{labels}{dc}(object, ...)

labels(object) <- value
}
\arguments{
\item{object}{a draws component object.}

\item{...}{currently not used.}

\item{value}{a vector of labels.}
}
\value{
The extractor function returns the variable labels.
}
\description{
Get and set the variable labels of a draws component object for a vector-valued parameter
}
\examples{
\donttest{
ex <- mcmcsae_example()
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=50, n.iter=100, n.chain=1, store.all=TRUE)
labels(sim$beta)
labels(sim$v)
labels(sim$beta) <- c("a", "b")
labels(sim$beta)
}

}
