% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mcvis.R
\name{plot.mcvis}
\alias{plot.mcvis}
\title{Multi-collinearity Visualization}
\usage{
\method{plot}{mcvis}(x, thres = 2/3, eig.max = 1, var.max = ncol(x$MC), ...)
}
\arguments{
\item{x}{Output of the mcvis function}

\item{thres}{A parameter determining below which thickness the plotting lines hide.}

\item{eig.max}{The maximum number of eigenvalues to be displayed on the plot.}

\item{var.max}{The maximum number of variables to be displayed on the plot.}

\item{...}{additional arguments (currently unused)}
}
\description{
Multi-collinearity Visualization
}
\examples{
set.seed(1)
p = 10
n = 100
X = matrix(rnorm(n*p), ncol = p)
X[,1] = X[,2] + rnorm(n, 0, 0.1)
mcvis_result = mcvis(X)
plot(mcvis_result, thres = 1)
}
\author{
Chen Lin, Kevin Wang, Samuel Mueller
}
