% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_na_as.R
\name{recode_na_as}
\alias{recode_na_as}
\title{Replace missing values with another value}
\usage{
recode_na_as(
  df,
  value = 0,
  subset_cols = NULL,
  pattern_type = NULL,
  pattern = NULL,
  case_sensitive = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.frame object for which recoding is to be done.}

\item{value}{The value to convert to `NA`. We can for instance change "n/a" to `NA` or any other value.}

\item{subset_cols}{An optional character vector to define columns for which changes are required.}

\item{pattern_type}{One of contains', 'starts_with' or 'ends_with'.}

\item{pattern}{A character pattern to match}

\item{case_sensitive}{Defaults to FALSE. Patterns are case insensitive if TRUE}

\item{...}{Other arguments to other functions}
}
\value{
An object of the same type as x with NAs replaced with the desired value.
}
\description{
This provides a convenient way to recode "NA" as another value for instance "NaN", "n/a" or
any other value a user wishes to use.
}
\examples{
head(recode_na_as(airquality, "n/a"))
head(recode_na_as(airquality, subset_cols = "Ozone", value = "N/A"))
head(recode_na_as(airquality, value=0, pattern_type="starts_with",pattern="Solar"))
}
