/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.scrollabledesktop;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import multidendrograms.forms.scrollabledesktop.BaseDesktopPane;
import multidendrograms.forms.scrollabledesktop.BaseInternalFrame;
import multidendrograms.forms.scrollabledesktop.BaseToggleButton;
import multidendrograms.forms.scrollabledesktop.DesktopListener;
import multidendrograms.forms.scrollabledesktop.DesktopMediator;
import multidendrograms.forms.scrollabledesktop.FramePositioning;

public class DesktopScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private DesktopMediator desktopMediator;
    private BaseDesktopPane desktopPane;
    private FramePositioning positioning;

    public DesktopScrollPane(DesktopMediator desktopMediator) {
        this.desktopMediator = desktopMediator;
        this.desktopPane = new BaseDesktopPane(this);
        this.setViewportView(this.desktopPane);
        this.positioning = new FramePositioning(this);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
        this.getHorizontalScrollBar().setUnitIncrement(5);
        this.getVerticalScrollBar().setUnitIncrement(5);
    }

    public BaseInternalFrame add(DesktopListener desktopListener, String string, ImageIcon imageIcon, JPanel jPanel, boolean bl, int n, int n2) {
        BaseInternalFrame baseInternalFrame = new BaseInternalFrame(string, imageIcon, jPanel, bl);
        baseInternalFrame.addComponentListener(desktopListener);
        this.initAndAddFrame(baseInternalFrame, n, n2);
        return baseInternalFrame;
    }

    public void add(DesktopListener desktopListener, JInternalFrame jInternalFrame, int n, int n2) {
        jInternalFrame.addComponentListener(desktopListener);
        this.initAndAddFrame(jInternalFrame, n, n2);
    }

    private void initAndAddFrame(JInternalFrame jInternalFrame, int n, int n2) {
        if (n != -1 && n2 != -1) {
            jInternalFrame.setLocation(n, n2);
        } else if (!this.getAutoTile()) {
            jInternalFrame.setLocation(this.cascadeInternalFrame(jInternalFrame));
        }
        this.desktopPane.add(jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.resizeDesktop();
    }

    public JInternalFrame[] getAllFrames() {
        return this.desktopPane.getAllFrames();
    }

    public JInternalFrame getSelectedFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    public void closeSelectedFrame() {
        JInternalFrame jInternalFrame = this.getSelectedFrame();
        if (jInternalFrame != null) {
            jInternalFrame.dispose();
        }
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        try {
            JInternalFrame jInternalFrame2 = this.desktopPane.getSelectedFrame();
            if (jInternalFrame2 != null) {
                jInternalFrame2.setSelected(false);
            }
            jInternalFrame.setSelected(true);
            jInternalFrame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            System.out.println(propertyVetoException.getMessage());
        }
    }

    public void flagContentsChanged(JInternalFrame jInternalFrame) {
        if (this.desktopPane.getSelectedFrame() != jInternalFrame) {
            BaseToggleButton baseToggleButton = (BaseToggleButton)((BaseInternalFrame)jInternalFrame).getAssociatedButton();
            baseToggleButton.flagContentsChanged(true);
        }
    }

    public void selectNextFrame() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length > 0) {
            try {
                jInternalFrameArray[0].setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("Bean veto: " + propertyVetoException.getMessage());
            }
        }
    }

    public int getNumberOfFrames() {
        return this.desktopPane.getComponentCount();
    }

    public void setDesktopSize(Dimension dimension) {
        this.desktopPane.setPreferredSize(dimension);
        this.desktopPane.revalidate();
    }

    public Dimension getDesktopSize() {
        return this.desktopPane.getPreferredSize();
    }

    public void setAutoTile(boolean bl) {
        this.positioning.setAutoTile(bl);
    }

    public boolean getAutoTile() {
        return this.positioning.getAutoTile();
    }

    public Point cascadeInternalFrame(JInternalFrame jInternalFrame) {
        return this.positioning.cascadeInternalFrame(jInternalFrame);
    }

    public void cascadeInternalFrames() {
        this.positioning.cascadeInternalFrames();
    }

    public void tileInternalFrames() {
        this.positioning.tileInternalFrames();
    }

    public void centerView(BaseInternalFrame baseInternalFrame) {
        Rectangle rectangle = this.getViewport().getViewRect();
        int n = baseInternalFrame.getX() + baseInternalFrame.getWidth() / 2 - rectangle.width / 2;
        int n2 = baseInternalFrame.getY() + baseInternalFrame.getHeight() / 2 - rectangle.height / 2;
        Dimension dimension = this.getDesktopSize();
        if (n + rectangle.width > dimension.width) {
            n = dimension.width - rectangle.width;
        } else if (n < 0) {
            n = 0;
        }
        if (n2 + rectangle.height > dimension.height) {
            n2 = dimension.height - rectangle.height;
        } else if (n2 < 0) {
            n2 = 0;
        }
        this.getViewport().setViewPosition(new Point(n, n2));
    }

    public void resizeDesktop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                Rectangle rectangle = DesktopScrollPane.this.getViewport().getViewRect();
                int n2 = rectangle.width + rectangle.x;
                int n3 = rectangle.height + rectangle.y;
                int n4 = rectangle.x;
                int n5 = rectangle.y;
                JInternalFrame jInternalFrame = null;
                JInternalFrame[] jInternalFrameArray = DesktopScrollPane.this.getAllFrames();
                for (n = 0; n < jInternalFrameArray.length; ++n) {
                    jInternalFrame = jInternalFrameArray[n];
                    if (jInternalFrame.getX() < n4) {
                        n4 = jInternalFrame.getX();
                    }
                    if (jInternalFrame.getX() + jInternalFrame.getWidth() > n2) {
                        n2 = jInternalFrame.getX() + jInternalFrame.getWidth();
                    }
                    if (jInternalFrame.getY() < n5) {
                        n5 = jInternalFrame.getY();
                    }
                    if (jInternalFrame.getY() + jInternalFrame.getHeight() <= n3) continue;
                    n3 = jInternalFrame.getY() + jInternalFrame.getHeight();
                }
                DesktopScrollPane.this.setVisible(false);
                if (n4 != 0 || n5 != 0) {
                    for (n = 0; n < jInternalFrameArray.length; ++n) {
                        jInternalFrame = jInternalFrameArray[n];
                        jInternalFrame.setLocation(jInternalFrame.getX() - n4, jInternalFrame.getY() - n5);
                    }
                    JViewport jViewport = DesktopScrollPane.this.getViewport();
                    jViewport.setViewSize(new Dimension(n2 - n4, n3 - n5));
                    jViewport.setViewPosition(new Point(rectangle.x - n4, rectangle.y - n5));
                    DesktopScrollPane.this.setViewport(jViewport);
                }
                DesktopScrollPane.this.setDesktopSize(new Dimension(n2 - n4, n3 - n5));
                DesktopScrollPane.this.setVisible(true);
            }
        });
    }

    public void removeAssociatedComponents(BaseInternalFrame baseInternalFrame) {
        this.desktopMediator.removeAssociatedComponents(baseInternalFrame);
    }
}

