% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFusionProbabiliy.R
\name{calcFusionProbabiliy}
\alias{calcFusionProbabiliy}
\title{Calculate fusion probability}
\usage{
calcFusionProbabiliy(mcmc, v, w, processed = FALSE)
}
\arguments{
\item{mcmc}{Output from ``runMCMCChain``}

\item{v}{First view considered.}

\item{w}{Second view considered.}

\item{processed}{Has the chain been processed already (defaults to FALSE).}
}
\value{
A vector of probabilities
}
\description{
The mean of the number of MCMC samples for which each item has
the same label in views v and w.
}
\examples{

N <- 100
X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
Y <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)

truth <- c(rep(1, N / 2), rep(2, N / 2))
data_modelled <- list(X, Y)

V <- length(data_modelled)

# This R is much too low for real applications
R <- 100
thin <- 5
burn <- 10

K_max <- 10
K <- rep(K_max, V)
types <- rep("G", V)

mcmc_out <- callMDI(data_modelled, R, thin, types, K = K)
calcFusionProbabiliy(mcmc_out, 1, 2)

}
