% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processMCMCChain.R
\name{processMCMCChain}
\alias{processMCMCChain}
\title{Process MCMC chain}
\usage{
processMCMCChain(
  mcmc_output,
  burn,
  point_estimate_method = "median",
  construct_psm = FALSE
)
}
\arguments{
\item{mcmc_output}{Output from ``batchSemiSupervisedMixtureModel``}

\item{burn}{The number of MCMC samples to drop as part of a burn in.}

\item{point_estimate_method}{Summary statistic used to define the point
estimate. Must be ``'mean'`` or ``'median'``. ``'median'`` is the default.}

\item{construct_psm}{Logical indicating if PSMs be constructed in the
unsupervised views. Defaults to FALSE. If TRUE the PSM is constructed and
this is used to infer the point estimate rather than the sampled partitions.}
}
\value{
A named list similar to the output of
``batchSemiSupervisedMixtureModel`` with some additional entries:
 * ``allocation_probability``: $(N x K)$ matrix. The point estimate of
 the allocation probabilities for each data point to each class.

 * ``prob``: $N$ vector. The point estimate of the probability of being
 allocated to the class with the highest probability.

 * ``pred``: $N$ vector. The predicted class for each sample.
}
\description{
Applies a burn in to and finds a point estimate for the output
of ``batchSemiSupervisedMixtureModel``.
}
\examples{
N <- 100
X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
Y <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)

truth <- c(rep(1, N / 2), rep(2, N / 2))
data_modelled <- list(X, Y)

V <- length(data_modelled)

# This R is much too low for real applications
R <- 100
thin <- 5
burn <- 10

K_max <- 10
K <- rep(K_max, V)
types <- rep("G", V)

mcmc_out <- callMDI(data_modelled, R, thin, types, K = K)
processMCMCChain(mcmc_out, burn)
}
