% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_regression.R
\name{MSLE}
\alias{MSLE}
\title{Mean squared logarithmic error}
\usage{
MSLE(truth, response)
}
\arguments{
\item{truth}{[numeric] vector of true values}

\item{response}{[numeric] vector of predicted values}
}
\description{
Defined as: mean((log(response + 1, exp(1)) - log(truth + 1, exp(1)))^2).
This is mostly used for count data, note that all predicted and actual target values must be greater or equal '-1'
to compute the mean squared logarithmic error.
}
\examples{
n = 20
set.seed(123)
truth = abs(rnorm(n))
response = abs(rnorm(n))
MSLE(truth, response)
}
