% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxaturn.R
\name{taxaturn}
\alias{taxaturn}
\title{Analyze the 'turnover' of taxa.}
\description{
Analyze the 'turnover' of taxa along a defined gradient.
The workflow of taxaturn class includes the taxonomic abundance calculation, abundance transformation, abundance change summary, statistical analysis and visualization.
}
\examples{

## ------------------------------------------------
## Method `taxaturn$new`
## ------------------------------------------------

data(wheat_16S)
t1 <- taxaturn$new(wheat_16S, taxa_level = "Phylum", group = "Type", 
 ordered_group = c("S", "RS", "R"), by_ID = "Plant_ID")

## ------------------------------------------------
## Method `taxaturn$cal_diff`
## ------------------------------------------------

t1$cal_diff(method = "wilcox")

## ------------------------------------------------
## Method `taxaturn$plot`
## ------------------------------------------------

t1$plot()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-taxaturn-new}{\code{taxaturn$new()}}
\item \href{#method-taxaturn-cal_diff}{\code{taxaturn$cal_diff()}}
\item \href{#method-taxaturn-plot}{\code{taxaturn$plot()}}
\item \href{#method-taxaturn-clone}{\code{taxaturn$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxaturn-new"></a>}}
\if{latex}{\out{\hypertarget{method-taxaturn-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxaturn$new(
  dataset,
  taxa_level = "Phylum",
  group,
  ordered_group,
  by_ID = NULL,
  by_group = NULL,
  filter_thres = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} class.}

\item{\code{taxa_level}}{default "Phylum"; taxonomic rank name, such as "Genus". An integer is also acceptable.
If the provided taxa_level is not found in \code{taxa_abund} list,
the function will invoke the \code{cal_abund} function to obtain the relative abudance automatically.}

\item{\code{group}}{sample group used for the selection; a colname of input \code{microtable$sample_table}.}

\item{\code{ordered_group}}{a vector representing the ordered elements of \code{group} parameter.}

\item{\code{by_ID}}{default NULL; a column of sample_table used to obtain the consistent change along provided elements.
So by_ID can be ID (unique repetition) or even group (with repetitions). 
If it denotes unique ID, consistent change can be performed across each ID.
It is also especially useful for the paired wilcox test (or paired t test) in the following analysis.
If it does not represent unique ID, the mean of each group will be calculated, and consistent change across groups will be obtained.}

\item{\code{by_group}}{default NULL; NULL or other colname of sample_table of input dataset used to show the result for different groups; 
   NULL represents the output is the default consistent change across all the elements in \code{by_ID};
a colname of sample_table of input dataset means the consistent change is obtained for each group instead of all the elements in \code{by_group};
Note that the by_group can be same with by_ID, in which the final change is the result of each element in \code{by_group}.
So generally \code{by_group} has a larger scale than \code{by_ID} parameter in terms of the sample numbers in each element.}

\item{\code{filter_thres}}{default 0; the mean abundance threshold used to filter features with low abudance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_change} and \code{res_abund}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(wheat_16S)
t1 <- taxaturn$new(wheat_16S, taxa_level = "Phylum", group = "Type", 
 ordered_group = c("S", "RS", "R"), by_ID = "Plant_ID")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxaturn-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-taxaturn-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Differential test of taxonomic abundance across groups
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxaturn$cal_diff(
  method = c("wilcox", "t.test", "betareg", "lme", "anova")[1],
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "wilcox"; see the following available options:
\describe{
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
  \item{\strong{'betareg'}}{Beta Regression based on the \code{betareg} package}
  \item{\strong{'lme'}}{lme: Linear Mixed Effect Model based on the \code{lmerTest} package}
  \item{\strong{'anova'}}{one-way or multi-way anova}
}}

\item{\code{...}}{parameters passed to \code{trans_diff$new}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_change} or \code{res_diff}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_diff(method = "wilcox")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxaturn-plot"></a>}}
\if{latex}{\out{\hypertarget{method-taxaturn-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the line chart.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxaturn$plot(
  select_taxon = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  delete_prefix = TRUE,
  plot_type = c("point", "line", "errorbar", "smooth")[1:3],
  errorbar_SE = TRUE,
  rect_fill = TRUE,
  rect_color = c("grey70", "grey90"),
  rect_alpha = 0.2,
  position = position_dodge(0.1),
  errorbar_size = 1,
  errorbar_width = 0.1,
  point_size = 3,
  point_alpha = 0.8,
  line_size = 0.8,
  line_alpha = 0.8,
  line_type = 1,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_taxon}}{default NULL; a taxon name.
Note that if \code{delete_prefix} is TRUE, the provided select_taxon should be taxa names without long prefix (those before |);
if \code{delete_prefix} is FALSE, the select_taxon should be full names same with those in the \code{res_abund} of the object.}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for the plotting.}

\item{\code{delete_prefix}}{default TRUE; whether delete the prefix in the taxa names.}

\item{\code{plot_type}}{default c("point", "line", "errorbar", "smooth")[1:3]; a vector of visualization types. Multiple elements are available. 
'smooth' denotes the fitting with \code{geom_smooth} function of ggplot2 package.}

\item{\code{errorbar_SE}}{default TRUE; TRUE: plot the errorbar with mean ± se; FALSE: plot the errorbar with mean ± sd.}

\item{\code{rect_fill}}{default TRUE; Whether fill color in each rectangular area.}

\item{\code{rect_color}}{default c("grey70", "grey90"); the colors used to fill different rectangular area.}

\item{\code{rect_alpha}}{default 0.2; the fill color transparency in rectangular area.}

\item{\code{position}}{default position_dodge(0.1); Position adjustment for the points and lines, either as a string (such as "identity"), 
or the result of a call to a position adjustment function.}

\item{\code{errorbar_size}}{default 1; errorbar size.}

\item{\code{errorbar_width}}{default 0.1; errorbar width.}

\item{\code{point_size}}{default 3; point size for taxa.}

\item{\code{point_alpha}}{default 0.8; point transparency.}

\item{\code{line_size}}{default 0.8; line size.}

\item{\code{line_alpha}}{default 0.8; line transparency.}

\item{\code{line_type}}{default 1; an integer; line type.}

\item{\code{...}}{parameters passed to \code{geom_smooth} when 'smooth' is in plot_type parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$plot()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxaturn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-taxaturn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxaturn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
