% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meetups.R
\name{get_meetup_events}
\alias{get_meetup_events}
\title{Get Meetup Events}
\usage{
get_meetup_events(urlname, key, fields = c("status", "id", "name"), ...)
}
\arguments{
\item{urlname}{string, URL name for the meetup. e.g 'R-Users-Sydney'}

\item{key}{an API key from https://www.meetup.com/meetup_api/}

\item{fields}{a charcter vector of the fields to return}

\item{...}{a named list where each element is a character vector for additional
parameters e.g. `list("omit" = c("member.photo", "member.event_context")`}
}
\value{
data.frame of meetup events for a meetup.
}
\description{
This function retrieves all meetup events for a meetup.
This is forced to be ordered in descending order and show both upcoming and
past events, therefore 'status' and 'desc' should not be passed as named
arguements to the `...` (dots) arguement.
}
\examples{
\dontrun{
get_meetup_events("R-Users-Sydney", "your_api_key")
}

}
