% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.metabind.R
\name{forest.metabind}
\alias{forest.metabind}
\title{Forest plot to display the result of a meta-analysis}
\usage{
\method{forest}{metabind}(
  x,
  leftcols,
  leftlabs,
  rightcols = c("effect", "ci"),
  rightlabs,
  common = x$common,
  random = x$random,
  overall = x$overall,
  subgroup = FALSE,
  hetstat = FALSE,
  overall.hetstat = x$overall.hetstat,
  prediction = x$prediction,
  lab.NA = "",
  col.square = gs("col.square"),
  col.square.lines = col.square,
  col.circle = gs("col.circle"),
  col.circle.lines = col.circle,
  col.diamond = gs("col.diamond"),
  col.diamond.common = col.diamond,
  col.diamond.random = col.diamond,
  col.diamond.lines = gs("col.diamond.lines"),
  col.diamond.lines.common = col.diamond.lines,
  col.diamond.lines.random = col.diamond.lines,
  col.predict = gs("col.predict"),
  col.predict.lines = gs("col.predict.lines"),
  type.common = NULL,
  type.random = NULL,
  type.predict = NULL,
  digits = gs("digits.forest"),
  digits.se = gs("digits.se"),
  digits.stat = gs("digits.stat"),
  digits.pval = max(gs("digits.pval") - 2, 2),
  digits.pval.Q = max(gs("digits.pval.Q") - 2, 2),
  digits.Q = gs("digits.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.I2 = max(gs("digits.I2") - 1, 0),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  print.subgroup.labels = x$with.subgroups,
  addrow.subgroups = print.subgroup.labels,
  smlab,
  calcwidth.pooled = overall,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{metabind}}.}

\item{leftcols}{A character vector specifying (additional) columns
to be plotted on the left side of the forest plot or a logical
value (see Details).}

\item{leftlabs}{A character vector specifying labels for
(additional) columns on left side of the forest plot (see
Details).}

\item{rightcols}{A character vector specifying (additional) columns
to be plotted on the right side of the forest plot or a logical
value (see Details).}

\item{rightlabs}{A character vector specifying labels for
(additional) columns on right side of the forest plot (see
Details).}

\item{common}{A logical indicating whether common effect estimates
should be plotted.}

\item{random}{A logical indicating whether random effects estimates
should be plotted.}

\item{overall}{A logical indicating whether overall summaries
should be plotted. This argument is useful in a meta-analysis
with subgroups if summaries should only be plotted on group
level.}

\item{subgroup}{A logical indicating whether subgroup results
should be shown in forest plot. This argument is useful in a
meta-analysis with subgroups if summaries should not be plotted
on group level.}

\item{hetstat}{Either a logical value indicating whether to print
results for heterogeneity measures at all or a character string
(see Details).}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{prediction}{A logical indicating whether prediction
interval(s) should be printed.}

\item{lab.NA}{A character string to label missing values.}

\item{col.square}{The colour for squares reflecting study's weight
in the meta-analysis.}

\item{col.square.lines}{The colour for the outer lines of squares
reflecting study's weight in the meta-analysis.}

\item{col.circle}{The colour for circles reflecting study weights
in the meta-analysis.}

\item{col.circle.lines}{The colour for the outer lines of circles
reflecting study's weight in the meta-analysis.}

\item{col.diamond}{The colour of diamonds representing the results
for common effect and random effects models.}

\item{col.diamond.common}{The colour of diamonds for common effect
estimates.}

\item{col.diamond.random}{The colour of diamonds for random effects
estimates.}

\item{col.diamond.lines}{The colour of the outer lines of diamonds
representing the results for common effect and random effects
models.}

\item{col.diamond.lines.common}{The colour of the outer lines of
diamond for common effect estimates.}

\item{col.diamond.lines.random}{The colour of the outer lines of
diamond for random effects estimates.}

\item{col.predict}{Background colour of prediction intervals.}

\item{col.predict.lines}{Colour of outer lines of prediction
intervals.}

\item{type.common}{A character string or vector specifying how to
plot common effect estimates.}

\item{type.random}{A character string or vector specifying how to
plot random effects estimates.}

\item{type.predict}{A character string or vector specifying how to
plot prediction intervals.}

\item{digits}{Minimal number of significant digits for treatment
effects, see \code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
errors, see \code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-statistic for test of overall effect, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity test, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistic Q, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for square
root of between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
statistic, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{print.subgroup.labels}{A logical indicating whether subgroup
label should be printed.}

\item{addrow.subgroups}{A logical value indicating whether an empty
row is printed between results for subgroups.}

\item{smlab}{A label for the summary measurex (printed at top of
figure).}

\item{calcwidth.pooled}{A logical indicating whether text for
common effect and random effects model should be considered to
calculate width of the column with study labels.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional graphical arguments (passed on to
\code{\link{forest.meta}}).}
}
\description{
Draws a forest plot in the active graphics window (using grid
graphics system).
}
\details{
A forest plot, also called confidence interval plot, is drawn in
the active graphics window. The forest functions in R package
\bold{meta} are based on the grid graphics system. In order to
print the forest plot, resize the graphics window and either use
\code{\link{dev.copy2eps}} or \code{\link{dev.copy2pdf}}. Another
possibility is to create a file using \code{\link{pdf}},
\code{\link{png}}, or \code{\link{svg}} and to specify the width
and height of the graphic (see \code{\link{forest.meta}} examples).

The arguments \code{leftcols} and \code{rightcols} can be used to
specify columns which are plotted on the left and right side of the
forest plot, respectively.

The arguments \code{leftlabs} and \code{rightlabs} can be used to
specify column headings which are plotted on left and right side of
the forest plot, respectively. For certain columns predefined
labels exist. For other columns, the column name will be used as a
label. It is possible to only provide labels for new columns (see
\code{\link{forest.meta}} examples). Otherwise the length of
\code{leftlabs} and \code{rightlabs} must be the same as the number
of printed columns, respectively. The value \code{NA} can be used
to specify columns which should use default labels.

Argument \code{hetstat} can be a character string to specify where
to print heterogeneity information:
\itemize{
\item row with results for common effect model (\code{hetstat =
"common"}),
\item row with results for random effects model (\code{hetstat =
"random"}),
\item rows with 'study' information (\code{hetstat = "study"}).
}
Otherwise, information on heterogeneity is printed in dedicated rows.
}
\examples{
data(Fleiss1993cont)

# Add some (fictitious) grouping variables:
#
Fleiss1993cont$age <- c(55, 65, 55, 65, 55)
Fleiss1993cont$region <- c("Europe", "Europe", "Asia", "Asia", "Europe")

m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "SMD")

# Conduct two subgroup analyses
#
mu1 <- update(m1, subgroup = age, bylab = "Age group")
mu2 <- update(m1, subgroup = region, bylab = "Region")

# Combine subgroup meta-analyses and show forest plot with subgroup
# results
#
mb1 <- metabind(mu1, mu2)
mb1
forest(mb1)

}
\seealso{
\code{\link{forest.meta}}, \code{\link{metabin}},
  \code{\link{metacont}}, \code{\link{metagen}},
  \code{\link{metabind}}, \code{\link{settings.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
