% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{bma}
\alias{bma}
\title{Bayesian Model Averaging}
\usage{
bma(
  meta,
  prior = 1,
  parameter = "d",
  summarize = "integrate",
  ci = 0.95,
  rel.tol = .Machine$double.eps^0.5
)
}
\arguments{
\item{meta}{list of meta-analysis models (fitted via
\code{\link{meta_random}} or \code{\link{meta_fixed}})}

\item{prior}{prior probabilities over models (possibly unnormalized). For instance, if the first model is as likely as models 2, 3 and 4 together: \code{prior = c(3,1,1,1)}. The default is a discrete uniform distribution over models.}

\item{parameter}{either the mean effect \code{"d"} or the heterogeneity \code{"tau"}
(i.e., the across-study standard deviation of population effect sizes).}

\item{summarize}{how to estimate parameter summaries (mean, median, SD,
etc.): Either by numerical integration (\code{summarize = "integrate"}) or
based on MCMC/Stan samples (\code{summarize = "stan"}).}

\item{ci}{probability for the credibility/highest-density intervals.}

\item{rel.tol}{relative tolerance used for numerical integration using
\code{\link[stats]{integrate}}. Use \code{rel.tol=.Machine$double.eps} for
maximal precision (however, this might be slow).}
}
\description{
Model averaging for different meta-analysis models (e.g., random-effects or
fixed-effects with different priors) based on the posterior model
probability.
}
\examples{
\donttest{
# model averaging for fixed and random effects
data(towels)
fixed <- meta_fixed(logOR, SE, study, towels)
random <- meta_random(logOR, SE, study, towels)

averaged <- bma(list("fixed" = fixed, "random" = random))
averaged
plot_posterior(averaged)
plot_forest(averaged, mar = c(4.5,20,4,.3))
}
}
