% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_default.R
\name{meta_default}
\alias{meta_default}
\title{Defaults for Model Averaging in Meta-Analysis}
\usage{
meta_default(y, SE, labels, data, field = "psychology", effect = "d", ...)
}
\arguments{
\item{y}{effect size per study. Can be provided as (1) a numeric vector, (2)
the quoted or unquoted name of the variable in \code{data}, or (3) a
\code{\link[stats]{formula}} to include discrete or continuous moderator
variables.}

\item{SE}{standard error of effect size for each study. Can be a numeric
vector or the quoted or unquoted name of the variable in \code{data}}

\item{labels}{optional: character values with study labels. Can be a
character vector or the quoted or unquoted name of the variable in
\code{data}}

\item{data}{data frame containing the variables for effect size \code{y},
standard error \code{SE}, \code{labels}, and moderators per study.}

\item{field}{either\code{"psychology"} or \code{"medicine"}}

\item{effect}{the type of effect size used in the meta-analysis: either
Cohen's d (\code{"d"}),
Fisher's z-transformed correlation (\code{"z"}),
or log-odds ratios (\code{"logOR"}).}

\item{...}{further arguments passed to \code{\link{meta_bma}}}
}
\description{
Wrapper with default prior for Bayesian meta-analysis.
Since version 0.6.6, the default priors for Cohen's d have been changed from a
normal distribution with scale=0.3 to a Cauchy distribution with scale=0.707.
Moreover, scale adjustments were implemented when using Fisher's z or log odds-ratios.
}
\details{
The prior distribution depends on the scale of the effect size that is used in
the meta-analysis (Cohen's d, Fisher's z, or log odds ratio). To ensure that
the results are comparable when transforming between different effect sizes,
it is necessary to adjust the scale of the prior distributions.
\itemize{
\item The distribution of Fisher's z is approximately half as wide as the
distribution of Cohen's d and hence the prior scale parameter is divided by two.
\item The distribution of the log odds ratio is approximately twice as wide as the
distribution of Cohen's d and hence the prior scale parameter is doubled.
}

For \code{field = "psychology"}, the following defaults are used:
\itemize{
\item \code{effect = "d"}: Cauchy distribution with scale=0.707 on the overall
    effect size (parameter d) and inverse gamma distribution with shape=1 and
    scale=.15 on the standard deviation of effect sizes across studies (parameter tau).
\item \code{effect = "z"}: Cauchy distribution with scale=0.3535 on d and
    inverse gamma with shape=1 and scale=.075 on tau.
\item \code{effect = "logOR"}: Cauchy distribution with scale=1.414 on d and
    inverse gamma with shape=1 and scale=0.3 on tau.
}

Currently, the same priors are used when specifying \code{field = "medicine"}.

Default prior distributions can be plotted using \code{\link{plot_default}}.
}
\examples{
\donttest{
data(towels)
set.seed(123)
md <- meta_default(logOR, SE, study, towels,
                   field = "psychology", effect = "logOR")
md
plot_forest(md)
}
}
\references{
Gronau, Q. F., Erp, S. V., Heck, D. W., Cesario, J., Jonas, K. J., & Wagenmakers, E.-J. (2017). A Bayesian model-averaged meta-analysis of the power pose effect with informed and default priors: the case of felt power. Comprehensive Results in Social Psychology, 2(1), 123-138. \doi{10.1080/23743603.2017.1326760}
}
\seealso{
\code{\link{meta_bma}}, \code{\link{plot_default}}
}
