% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PAIRED_MEANS.R
\name{es_from_means_sd_pre_post}
\alias{es_from_means_sd_pre_post}
\title{Convert pre-post means of two independent groups into various effect size measures}
\usage{
es_from_means_sd_pre_post(
  mean_pre_exp,
  mean_exp,
  mean_pre_sd_exp,
  mean_sd_exp,
  mean_pre_nexp,
  mean_nexp,
  mean_pre_sd_nexp,
  mean_sd_nexp,
  n_exp,
  n_nexp,
  r_pre_post_exp,
  r_pre_post_nexp,
  smd_to_cor = "viechtbauer",
  pre_post_to_smd = "bonett",
  reverse_means_pre_post
)
}
\arguments{
\item{mean_pre_exp}{mean of the experimental/exposed group at baseline}

\item{mean_exp}{mean of the experimental/exposed group at follow up}

\item{mean_pre_sd_exp}{standard deviation of the experimental/exposed group at baseline}

\item{mean_sd_exp}{standard deviation of the experimental/exposed group at follow up}

\item{mean_pre_nexp}{mean of the non-experimental/non-exposed group at baseline}

\item{mean_nexp}{mean of the non-experimental/non-exposed group at follow up}

\item{mean_pre_sd_nexp}{standard deviation of the non-experimental/non-exposed group at baseline}

\item{mean_sd_nexp}{standard deviation of the non-experimental/non-exposed group at follow up}

\item{n_exp}{number of the experimental/exposed group}

\item{n_nexp}{number of the non-experimental/non-exposed group}

\item{r_pre_post_exp}{pre-post correlation in the experimental/exposed group}

\item{r_pre_post_nexp}{pre-post correlation in the non-experimental/non-exposed group}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{pre_post_to_smd}{formula used to convert the pre and post means/SD into a SMD (see details).}

\item{reverse_means_pre_post}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 15. Paired: pre-post means and dispersion'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert pre-post means of two independent groups into various effect size measures
}
\details{
This function converts pre-post means of two independent groups into a Cohen's d (D) and Hedges' g (G).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{Two approaches can be used to compute the Cohen's d.}

In these two approaches, the standard deviation of the difference within each group first needs to be obtained:
\deqn{adj\_exp = 2*r\_pre\_post\_exp*mean\_pre\_sd\_exp*mean\_sd\_exp}
\deqn{sd\_change\_exp = \sqrt{mean\_pre\_sd\_exp^2 + mean\_sd\_exp^2 - adj\_exp}}
\deqn{adj\_nexp = 2*r\_pre\_post\_nexp*mean\_pre\_sd\_nexp*mean\_sd\_nexp}
\deqn{sd\_change\_nexp = \sqrt{mean\_pre\_sd\_nexp^2 + mean\_sd\_nexp^2 - adj\_nexp}}
\enumerate{
\item In the approach described by Bonett (\code{pre_post_to_smd = "bonett"}), one Cohen's d per group is obtained by
standardizing the pre-post mean difference by the standard deviation at baseline (Bonett, 2008):
\deqn{cohen\_d\_exp = \frac{mean\_pre\_exp - mean\_exp}{mean\_pre\_sd\_exp}}
\deqn{cohen\_d\_nexp = \frac{mean\_pre\_nexp - mean\_nexp}{mean\_pre\_sd\_nexp}}
\deqn{cohen\_d\_se\_exp = \sqrt{\frac{sd\_change\_exp^2}{mean\_pre\_sd\_exp^2 * (n\_exp - 1) + g\_exp^2 / (2 * (n\_exp - 1))}}}
\deqn{cohen\_d\_se\_nexp = \sqrt{\frac{sd\_change\_nexp^2}{mean\_pre\_sd\_nexp^2 * (n\_nexp - 1) + g\_nexp^2 / (2 * (n\_nexp - 1))}}}
\item In the approach described by Cooper (\code{pre_post_to_smd = "cooper"}), the following formulas are used:
\deqn{cohen\_d\_exp = \frac{mean\_pre\_exp - mean\_exp}{sd\_change\_exp} * \sqrt{2 * (1 - r\_pre\_post\_exp)}}
\deqn{cohen\_d\_nexp = \frac{mean\_pre\_nexp - mean\_nexp}{sd\_change\_nexp} * \sqrt{2 * (1 - r\_pre\_post\_nexp)}}
\deqn{cohen\_d\_se\_exp = \frac{2 * (1 - r\_pre\_post\_exp)}{n\_exp} + \frac{cohen\_d\_exp^2}{2 * n\_exp}}
\deqn{cohen\_d\_se\_nexp = \frac{2 * (1 - r\_pre\_post\_nexp)}{n\_nexp} + \frac{cohen\_d\_nexp^2}{2 * n\_nexp}}
}

Last, the Cohen's d reflecting the within-group change from baseline to follow-up are combined into one Cohen's d:
\deqn{cohen\_d = d\_exp - d\_nexp}
\deqn{cohen\_d\_se = \sqrt{cohen\_d\_se\_exp^2 + cohen\_d\_se\_nexp^2}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_means_sd_pre_post(
  n_exp = 36, n_nexp = 35,
  mean_pre_exp = 98, mean_exp = 102,
  mean_pre_sd_exp = 16, mean_sd_exp = 17,
  mean_pre_nexp = 96, mean_nexp = 102,
  mean_pre_sd_nexp = 14, mean_sd_nexp = 15,
  r_pre_post_exp = 0.8, r_pre_post_nexp = 0.8
)
}
\references{
Bonett, S. B. (2008). Estimating effect sizes from pretest-posttest-control group designs. Organizational Research Methods, 11(2), 364–386. https://doi.org/10.1177/1094428106291059

Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
