#' iMK735 metabolic models in hypoxia and normoxia
#'
#' @name iMK735
#' @docType data
#' @usage data(iMK735)
#' @author Kavscek et al.
#' @references Kavšček, M., Bhutada, G., Madl, T. & Natter, K. (2015) Optimization of lipid production with a genome-scale model of Yarrowia lipolytica. BMC Syst. Biol. 9, 72.
NULL


#' Gene expression from Maguire et al. RNA-seq data
#'
#' @name exprMaguire
#' @docType data
#' @usage data(exprMaguire)
#' @author Maguire et al.
#' @references Maguire, S. L. et al. (2014) Zinc finger transcription factors displaced SREBP proteins as the major Sterol regulators during Saccharomycotina evolution. PLoS Genet. 10, e1004076.
NULL


#' GO annotation retrieved from Uniprot
#'
#' @name yarli2GO
#' @docType data
#' @usage data(yarli2GO)
#' @source Uniprot
#' @references Tran, V.D.T. et al. (2018) Condition-specific series of metabolic sub-networks and its application for gene set enrichment analysis. Bioinformatics 35(13), 2258-2266.
NULL


#' Submodel construction example for Yarrowia lipolytica
#'
#' @name yarliSubmnets
#' @docType data
#' @usage data(yarliSubmnets)
#' @author Van Du T. Tran
#' @references Tran, V.D.T. et al. (2018) Condition-specific series of metabolic sub-networks and its application for gene set enrichment analysis. Bioinformatics 35(13), 2258-2266.
NULL


#' Gene set enrichment example for Yarrowia lipolytica
#'
#' @name yarliGSE
#' @docType data
#' @usage data(yarliGSE)
#' @author Van Du T. Tran
#' @references Tran, V.D.T. et al. (2018) Condition-specific series of metabolic sub-networks and its application for gene set enrichment analysis. Bioinformatics 35(13), 2258-2266.
NULL
