% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_taxonomy--internal.R
\name{class_to_taxonomy}
\alias{class_to_taxonomy}
\title{List of classifications to taxonomy tree}
\usage{
class_to_taxonomy(classifications, id_column, obs_data = NULL)
}
\arguments{
\item{classifications}{(\code{list} of \code{data.frame}) 
The classifications of a set of observations.
Not necessarily unique.
Rows should correspond to taxa and columns to information associated with those taxa.}

\item{id_column}{(\code{character} of length 1)
The name of the column present in each \code{data.frame} in \code{classifications} that will
be used to infer the taxonomic tree structure.}

\item{obs_data}{(\code{data.frame}) 
Data associated with the \code{classifications}.}
}
\value{
An object of type \code{taxmap}
}
\description{
Convert a list of classifications to a taxonomic tree structure.
Columns in the input not used to create the taxonomy are preserved in the output.
Unique IDs can be assigned if the column used to create the taxonomy does not
have unique values for place in the hierarchy (e.g. same species epithet in different phlya.)
Missing data does not effect the taxonomy, but its positon is preserved in the observation output.
}
\keyword{internal}

