% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_tree_matrix.R
\name{heat_tree_matrix}
\alias{heat_tree_matrix}
\title{Plot a matrix of heat trees}
\usage{
heat_tree_matrix(obj, data, label_small_trees = FALSE, key_size = 0.6,
  seed = 1, output_file = NULL,
  row_label_color = diverging_palette()[3],
  col_label_color = diverging_palette()[1], row_label_size = 12,
  col_label_size = 12, ..., dataset = NULL)
}
\arguments{
\item{obj}{A \code{\link[taxa]{taxmap}} object}

\item{data}{The name of a table in \code{obj$data} that is the output of 
\code{\link{compare_groups}} or in the same format.}

\item{label_small_trees}{If \code{TRUE} add labels to small trees as well as 
the key tree. Otherwise, only the key tree will be labeled.}

\item{key_size}{The size of the key tree relative to the whole graph. For
example, 0.5 means half the width/height of the graph.}

\item{seed}{That random seed used to make the graphs.}

\item{output_file}{The path to one or more files to save the plot in using \code{\link[ggplot2]{ggsave}}. 
The type of the file will be determined by the extension given.
Default: Do not save plot.}

\item{row_label_color}{The color of the row labels on the right side of the matrix. Default:
based on the node_color_range.}

\item{col_label_color}{The color of the columns labels along the top of the matrix. Default:
based on the node_color_range.}

\item{row_label_size}{The size of the row labels on the right side of the matrix. Default: 12.}

\item{col_label_size}{The size of the columns labels along the top of the matrix. Default: 12.}

\item{...}{Passed to \code{\link{heat_tree}}. Some options will be overwritten.}

\item{dataset}{DEPRECIATED. use "data" instead.}
}
\description{
Plot a matrix of heat trees for showing pairwise comparisons. A larger,
labelled tree serves as a key for the matrix of smaller unlabelled trees. The
data for this function is typically created with \code{\link{compare_groups}},
}
\examples{
\dontrun{
# Parse dataset for plotting
x <- parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                    class_key = c(tax_rank = "info", tax_name = "taxon_name"),
                    class_regex = "^(.+)__(.+)$")

# Convert counts to proportions
x$data$otu_table <- calc_obs_props(x, data = "tax_data", cols = hmp_samples$sample_id)

# Get per-taxon counts
x$data$tax_table <- calc_taxon_abund(x, data = "otu_table", cols = hmp_samples$sample_id)

# Calculate difference between treatments
x$data$diff_table <- compare_groups(x, data = "tax_table",
                                    cols = hmp_samples$sample_id,
                                    groups = hmp_samples$body_site)

# Plot results (might take a few minutes)
heat_tree_matrix(x,
                 data = "diff_table",
                 node_size = n_obs,
                 node_label = taxon_names,
                 node_color = log2_median_ratio,
                 node_color_range = diverging_palette(),
                 node_color_trans = "linear",
                 node_color_interval = c(-3, 3),
                 edge_color_interval = c(-3, 3),
                 node_size_axis_label = "Number of OTUs",
                 node_color_axis_label = "Log2 ratio median proportions")

}

}
